<?php

declare (strict_types = 1);

if (! defined('WP_UNINSTALL_PLUGIN')) {
	exit;
}

$opt_key  = 'wp_inview_settings';
$settings = get_option($opt_key, null);

$remove = false;
if (is_array($settings)) {
	$remove = ! empty($settings['general']['removeDataOnUninstall']);
}

if (! $remove) {
	return;
}

// Options
delete_option('wp_inview_settings');
delete_option('_wp_inview_debug_last_posted');
delete_option('_wp_inview_debug_last_sanitized');

// Transients (Settings cache + Rate limit)
delete_transient('wp_inview_last_reset');
delete_transient('wp_inview_settings_cache_v1');