<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

trait WP_InView_Schema_Registry {

	public static function presets_registry(): array {
		if (is_array(self::$cache_registry)) {
			return self::$cache_registry;
		}

		self::$cache_registry = [
			'move' => [
				'label'       => __('Move', 'wp-inview'),
				'description' => __('Move + fade-in (directional translate).', 'wp-inview'),
				'order'       => 10,
				'fields'      => [
					'once'          => ['type' => 'bool', 'default' => true, 'group' => 'base'],
					'triggerPreset' => ['type' => 'string', 'default' => 'natural', 'group' => 'trigger'],
					'direction'     => ['type' => 'string', 'default' => 'up', 'group' => 'motion'],
					'distance'      => ['type' => 'int', 'default' => 24, 'group' => 'motion'],
					'opacityFrom'   => ['type' => 'float', 'default' => 0, 'group' => 'timing'],
					'duration'      => ['type' => 'int', 'default' => 650, 'group' => 'timing'],
					'delay'         => ['type' => 'int', 'default' => 0, 'group' => 'timing'],
					'easing'        => ['type' => 'string', 'default' => 'cubic-bezier(0.12, 1, 0.42, 1)', 'group' => 'timing'],
					'threshold'     => ['type' => 'float', 'default' => 0, 'group' => 'trigger'],
					'rootMargin'    => ['type' => 'string', 'default' => '0px 0px -2% 0px', 'group' => 'trigger'],
				],
			],

			'fade' => [
				'label'       => __('Fade', 'wp-inview'),
				'description' => __('Fade-in only (no translate).', 'wp-inview'),
				'order'       => 20,
				'fields'      => [
					'once'          => ['type' => 'bool', 'default' => true, 'group' => 'base'],
					'triggerPreset' => ['type' => 'string', 'default' => 'natural', 'group' => 'trigger'],
					'opacityFrom'   => ['type' => 'float', 'default' => 0, 'group' => 'timing'],
					'duration'      => ['type' => 'int', 'default' => 650, 'group' => 'timing'],
					'delay'         => ['type' => 'int', 'default' => 0, 'group' => 'timing'],
					'easing'        => ['type' => 'string', 'default' => 'cubic-bezier(0.12, 1, 0.42, 1)', 'group' => 'timing'],
					'threshold'     => ['type' => 'float', 'default' => 0, 'group' => 'trigger'],
					'rootMargin'    => ['type' => 'string', 'default' => '0px 0px -2% 0px', 'group' => 'trigger'],
				],
			],

			'zoom' => [
				'label'       => __('Zoom', 'wp-inview'),
				'description' => __('Zoom + fade-in with optional rubber finish.', 'wp-inview'),
				'order'       => 30,
				'fields'      => [
					'once'          => ['type' => 'bool', 'default' => true, 'group' => 'base'],
					'triggerPreset' => ['type' => 'string', 'default' => 'natural', 'group' => 'trigger'],
					'zoomMode'      => ['type' => 'string', 'default' => 'in', 'group' => 'zoom'],
					'scaleFrom'     => ['type' => 'float', 'default' => 0.95, 'group' => 'zoom'],
					'rubberMode'    => ['type' => 'string', 'default' => 'off', 'group' => 'rubber'],
					'rubberAmp'     => ['type' => 'float', 'default' => 0.035, 'group' => 'rubber'],
					'rubber'        => ['type' => 'bool', 'default' => false, 'group' => 'rubber'],
					'opacityFrom'   => ['type' => 'float', 'default' => 0, 'group' => 'timing'],
					'duration'      => ['type' => 'int', 'default' => 650, 'group' => 'timing'],
					'delay'         => ['type' => 'int', 'default' => 0, 'group' => 'timing'],
					'easing'        => ['type' => 'string', 'default' => 'cubic-bezier(0.12, 1, 0.42, 1)', 'group' => 'timing'],
					'threshold'     => ['type' => 'float', 'default' => 0, 'group' => 'trigger'],
					'rootMargin'    => ['type' => 'string', 'default' => '0px 0px -2% 0px', 'group' => 'trigger'],
				],
			],

			'blur' => [
				'label'       => __('Blur', 'wp-inview'),
				'description' => __('Blur + fade-in (backdrop-filter blur).', 'wp-inview'),
				'order'       => 40,
				'fields'      => [
					'once'          => ['type' => 'bool', 'default' => true, 'group' => 'base'],
					'blurFrom'      => ['type' => 'float', 'default' => 10],
					'triggerPreset' => ['type' => 'string', 'default' => 'natural', 'group' => 'trigger'],
					'opacityFrom'   => ['type' => 'float', 'default' => 0, 'group' => 'timing'],
					'duration'      => ['type' => 'int', 'default' => 650, 'group' => 'timing'],
					'delay'         => ['type' => 'int', 'default' => 0, 'group' => 'timing'],
					'easing'        => ['type' => 'string', 'default' => 'cubic-bezier(0.12, 1, 0.42, 1)', 'group' => 'timing'],
					'threshold'     => ['type' => 'float', 'default' => 0, 'group' => 'trigger'],
					'rootMargin'    => ['type' => 'string', 'default' => '0px 0px -2% 0px', 'group' => 'trigger'],
				],
			],

			'mask' => [
				'label'       => __('Mask reveal', 'wp-inview'),
				'description' => __('Reveals content using a CSS mask. Looks modern and clean.', 'wp-inview'),
				'order'       => 50,
				'fields'      => [
					'once'          => ['type' => 'bool', 'default' => true],
					'opacityFrom'   => ['type' => 'float', 'default' => 0],
					'duration'      => ['type' => 'int', 'default' => 650],
					'delay'         => ['type' => 'int', 'default' => 0],
					'easing'        => ['type' => 'string', 'default' => 'cubic-bezier(0.12, 1, 0.42, 1)'],
					'triggerPreset' => ['type' => 'string', 'default' => 'natural'],
					'threshold'     => ['type' => 'float', 'default' => 0],
					'rootMargin'    => ['type' => 'string', 'default' => '0px 0px -2% 0px'],
					'maskVariant'   => ['type' => 'string', 'default' => 'wipe'],
					'maskDirection' => ['type' => 'string', 'default' => 'up'],
					'maskFeather'   => ['type' => 'int', 'default' => 24],
					'maskInset'     => ['type' => 'int', 'default' => 20],
				],
			],
		];

		return self::$cache_registry;
	}

	/**
	 * Registry for Page Transition variants.
	 *
	 * @return array<string,array<string,mixed>>
	 */
	public static function page_transition_registry(): array {
		return [
			'fade'    => [
				'label'       => __('Fade', 'wp-inview'),
				'description' => __('Smooth fade through custom color.', 'wp-inview'),
				'available'   => true,
				'version'     => '1.0',
				'order'       => 10,
				'fields'      => [
					'duration'       => ['type' => 'int', 'default' => 450],
					'easing'         => ['type' => 'string', 'default' => 'cubic-bezier(0.12, 1, 0.42, 1)'],
					'overlayColor'   => ['type' => 'string', 'default' => '#ffffff'],
					'overlayOpacity' => ['type' => 'float', 'default' => 1.0],
				],
			],

			'blur'    => [
				'label'       => __('Blur', 'wp-inview'),
				'description' => __('Fades through overlay color while blurring the page content.', 'wp-inview'),
				'available'   => true,
				'version'     => '1.2',
				'order'       => 20,
				'fields'      => [
					'duration'       => ['type' => 'int', 'default' => 500],
					'easing'         => ['type' => 'string', 'default' => 'cubic-bezier(0.12, 1, 0.42, 1)'],
					'blurAmount'     => ['type' => 'int', 'default' => 10],
					'overlayColor'   => ['type' => 'string', 'default' => '#ffffff'],
					'overlayOpacity' => ['type' => 'float', 'default' => 1],
				],
			],

			'curtain' => [
				'label'       => __('Curtain', 'wp-inview'),
				'description' => __('Overlay slides in from chosen direction, then exits the opposite way.', 'wp-inview'),
				'available'   => true,
				'version'     => '1.1',
				'order'       => 30,
				'fields'      => [
					'duration'       => ['type' => 'int', 'default' => 600],
					'easing'         => ['type' => 'string', 'default' => 'cubic-bezier(0.12, 1, 0.42, 1)'],
					'direction'      => ['type' => 'string', 'default' => 'left'],
					'overlayColor'   => ['type' => 'string', 'default' => '#ffffff'],
					'overlayOpacity' => ['type' => 'float', 'default' => 1.0],
				],
			],
		];
	}
}