<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

trait WP_InView_Schema_Helpers {

	private static function ui_anim_fields(): array {
		$ui     = self::ui_schema();
		$anim   = is_array($ui['animation'] ?? null) ? $ui['animation'] : [];
		$fields = is_array($anim['fields'] ?? null) ? $anim['fields'] : [];
		return $fields;
	}

	private static function ui_field(string $key): array {
		$fields = self::ui_anim_fields();
		$f      = $fields[$key] ?? [];
		return is_array($f) ? $f : [];
	}

	private static function allowed_for(string $fieldKey): array {
		$f       = self::ui_field($fieldKey);
		$allowed = $f['allowed'] ?? [];
		return is_array($allowed) ? array_values($allowed) : [];
	}

	private static function ui_pt_fields(): array {
		$ui     = self::ui_schema();
		$pt     = is_array($ui['pageTransition'] ?? null) ? $ui['pageTransition'] : [];
		$fields = is_array($pt['fields'] ?? null) ? $pt['fields'] : [];
		return $fields;
	}

	private static function ui_pt_field(string $key): array {
		$fields = self::ui_pt_fields();
		$f      = $fields[$key] ?? [];
		return is_array($f) ? $f : [];
	}

	private static function allowed_for_pt(string $fieldKey): array {
		$f       = self::ui_pt_field($fieldKey);
		$allowed = $f['allowed'] ?? [];
		return is_array($allowed) ? array_values($allowed) : [];
	}

	private static function sanitize_enum_value(array $allowed, string $val, string $default): string {
		if (! $allowed) {
			return $default;
		}

		return in_array($val, $allowed, true) ? $val : $default;
	}

	private static function sanitize_enum(string $fieldKey, string $val, string $default): string {
		$allowed = self::allowed_for($fieldKey);
		return self::sanitize_enum_value($allowed, $val, $default);
	}

	private static function clamp_int($val, int $min, int $max): int {
		$n = (int) $val;
		if ($n < $min) {
			return $min;
		}

		if ($n > $max) {
			return $max;
		}

		return $n;
	}

	private static function clamp_float($val, float $min, float $max): float {
		$n = (float) $val;
		if ($n < $min) {
			return $min;
		}

		if ($n > $max) {
			return $max;
		}

		return $n;
	}

	private static function sanitize_text_maxlen($val, int $maxLen): string {
		$s = is_string($val) ? trim($val) : ($val === null ? '' : trim((string) $val));

		if ($maxLen > 0) {
			if (function_exists('mb_strlen') && function_exists('mb_substr')) {
				if (mb_strlen($s) > $maxLen) {
					$s = (string) mb_substr($s, 0, $maxLen);
				}
			} else {
				if (strlen($s) > $maxLen) {
					$s = substr($s, 0, $maxLen);
				}
			}
		}

		return $s;
	}

	private static function sanitize_root_margin($val, string $default): string {
		$ui     = self::ui_field('rootMargin');
		$maxLen = isset($ui['maxLen']) ? (int) $ui['maxLen'] : 0;

		$s = self::sanitize_text_maxlen($val, $maxLen);
		if ($s === '') {
			return $default;
		}
		return $s;
	}
}