<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

trait WP_InView_Schema_Defaults {

	public static function defaults(): array {
		if (is_array(self::$cache_defaults)) {
			return self::$cache_defaults;
		}

		$out = [
			'schemaVersion'  => (int) self::SCHEMA_VERSION,
			'ui'             => [
				'language'           => 'auto',    // 'auto' | 'en' | 'pl'
				'editorPanelMode'    => 'sidebar', // 'popup' | 'sidebar'
				'showListViewBadges' => true,      // show preset badge in List View sidebar
			],

			'general'        => [
				'removeDataOnUninstall' => false,
			],

			'animation'      => [
				'settings' => [
					'enabled' => true,
				],
				'presets'  => [],
				'cascade'  => [
					'step'     => 120,
					'limit'    => 24,
					'selector' => '',
				],
			],

			'pageTransition' => [
				'enabled'       => false,
				'activeVariant' => 'fade',
				'variants'      => [],
			],
		];

		// Initialise default values for each animation preset
		// based on fields defined in presets_registry().
		foreach (self::presets_registry() as $presetKey => $presetDef) {
			$fields                                  = is_array($presetDef['fields'] ?? null) ? $presetDef['fields'] : [];
			$out['animation']['presets'][$presetKey] = [];

			foreach ($fields as $fieldKey => $fieldDef) {
				$out['animation']['presets'][$presetKey][$fieldKey] = $fieldDef['default'] ?? null;
			}
		}

		// Initialise default values for each page transition variant
		// based on fields defined in page_transition_registry().
		foreach (self::page_transition_registry() as $variantKey => $variantDef) {
			$fields = is_array($variantDef['fields'] ?? null) ? $variantDef['fields'] : [];

			$out['pageTransition']['variants'][$variantKey] = [
				// Only 'fade' is enabled by default; others are placeholders.
				'enabled' => ($variantKey === 'fade'),
			];

			foreach ($fields as $fieldKey => $fieldDef) {
				$out['pageTransition']['variants'][$variantKey][$fieldKey] = $fieldDef['default'] ?? null;
			}
		}

		self::$cache_defaults = $out;
		return self::$cache_defaults;
	}

	/**
	 * Returns a compressed { defaults, ui } package used by admin JS
	 * (window.WP_INVIEW_GLOBALS) and the block editor.
	 *
	 * Do NOT cache statically — strings in ui_schema() are wrapped in __()
	 * and must be evaluated after load_plugin_textdomain().
	 *
	 * @return array<string, mixed>
	 */
	public static function package(): array {
		if (is_array(self::$cache_package)) {
			return self::$cache_package;
		}

		self::$cache_package = [
			'defaults' => self::defaults(),
			'ui'       => self::ui_schema(),
		];

		return self::$cache_package;
	}
}