<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

$__wp_inview_schema_files = [
	__DIR__ . '/Schema/Registry.php',
	__DIR__ . '/Schema/UI.php',
	__DIR__ . '/Schema/Defaults.php',
	__DIR__ . '/Schema/Helpers.php',
	__DIR__ . '/Schema/Normalize.php',
];

// Prevent Fatal Errors
foreach ($__wp_inview_schema_files as $__file) {
	// Check if file exists BEFORE requiring
	if (! file_exists($__file)) {
		// Log the error
		if (class_exists('WP_InView_Debug')) {
			WP_InView_Debug::error('Missing required schema file', [
				'path'     => $__file,
				'exists'   => file_exists($__file),
				'readable' => is_readable($__file),
			]);
		}

		if (is_admin()) {
			// In admin, show notice
			add_action('admin_notices', function () use ($__file) {
				$filename = basename($__file);
				echo '<div class="notice notice-error"><p>';
				echo '<strong>' . esc_html__('WP InView Error', 'wp-inview') . ':</strong> ';
				echo sprintf(
					esc_html__('Critical plugin file missing: %s. Please reinstall the plugin.', 'wp-inview'),
					esc_html($filename)
				);
				echo '</p></div>';
			});
			return;
		} else {
			error_log('[WP InView] CRITICAL: Missing schema file: ' . $__file);
			return;
		}
	}

	require_once $__file;
}
unset($__wp_inview_schema_files, $__file);

/* This file must be loaded before any Settings/Admin code. */

final class WP_InView_Schema {

	public const SCHEMA_VERSION = 1;

	/** @var array<string,mixed>|null */
	private static $cache_registry = null;

	/** @var array<string,mixed>|null */
	private static $cache_ui = null;

	/** @var array<string,mixed>|null */
	private static $cache_defaults = null;

	/** @var array<string,mixed>|null */
	private static $cache_package = null;

	use WP_InView_Schema_Registry;
	use WP_InView_Schema_UI;
	use WP_InView_Schema_Defaults;
	use WP_InView_Schema_Helpers;
	use WP_InView_Schema_Normalize;

	private function __construct() {
	}

	public static function flush_cache(): void {
		self::$cache_registry = null;
		self::$cache_ui       = null;
		self::$cache_defaults = null;
		self::$cache_package  = null;

	}
}