<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

final class WP_InView_Loader {

	public static function load_core(): void {
		require_once WP_INVIEW_DIR . 'includes/Debug.php';
		require_once WP_INVIEW_DIR . 'includes/Helpers.php';
		require_once WP_INVIEW_DIR . 'includes/Schema.php';
		require_once WP_INVIEW_DIR . 'includes/Settings.php';
		require_once WP_INVIEW_DIR . 'includes/Assets.php';
		require_once WP_INVIEW_DIR . 'includes/ViewHelpers.php';
	}

	public static function load_admin(): void {
		require_once WP_INVIEW_DIR . 'includes/Admin.php';
		require_once WP_INVIEW_DIR . 'includes/Admin/ViewHelpers.php';

		// NEW: admin routing + view
		require_once WP_INVIEW_DIR . 'includes/Admin/PageController.php';

		require_once WP_INVIEW_DIR . 'includes/Admin/Tabs/Animation.php';
		require_once WP_INVIEW_DIR . 'includes/Admin/Tabs/Cascade.php';
		require_once WP_INVIEW_DIR . 'includes/Admin/Tabs/Settings.php';
		require_once WP_INVIEW_DIR . 'includes/Admin/Tabs/PageTransition.php';
	}

	public static function load(): void {
		self::load_core();

		if (function_exists('is_admin') && is_admin()) {
			self::load_admin();
		}
	}
}