<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

final class WP_InView_Helpers {

	public static function path(string $rel): string {
		if (! defined('WP_INVIEW_DIR')) {
			if (class_exists('WP_InView_Debug')) {
				WP_InView_Debug::error('WP_INVIEW_DIR is not defined when building path', ['rel' => $rel]);
			}
			return ltrim($rel, '/');
		}

		return WP_INVIEW_DIR . ltrim($rel, '/');
	}

	public static function url(string $rel): string {
		if (! defined('WP_INVIEW_URL')) {
			if (class_exists('WP_InView_Debug')) {
				WP_InView_Debug::error('WP_INVIEW_URL is not defined when building url', ['rel' => $rel]);
			}
			return ltrim($rel, '/');
		}

		return trailingslashit(WP_INVIEW_URL) . ltrim($rel, '/');
	}

	public static function file_exists(string $rel): bool {
		// Heuristic: absolute paths probably indicate misuse of this helper.
		if ($rel !== '' && ($rel[0] === '/' || preg_match('/^[A-Za-z]:\\\\/', $rel) === 1)) {
			if (class_exists('WP_InView_Debug')) {
				WP_InView_Debug::warn('WP_InView_Helpers::file_exists expects a relative path', ['rel' => $rel]);
			}
		}

		return file_exists(self::path($rel));
	}
}