<?php
	// includes/Admin/Views/tabs/settings/layout.php

	if (! defined('ABSPATH')) {
	exit;
	}

	/** @var array<string,mixed> $ctx */
	$lang           = (string) ($ctx['lang'] ?? 'auto');
	$panel_mode     = (string) ($ctx['panel_mode'] ?? 'popup');
	$show_lv_badges = (bool) ($ctx['show_lv_badges'] ?? true);
	$just_reset     = ! empty($ctx['just_reset']);
	$option_key     = (string) ($ctx['option_key'] ?? 'wp_inview_settings');
?>

<div class="wp-inview-card-wrap">
  <h2 class="wp-inview-card__title"><?php echo esc_html__('Settings', 'wp-inview'); ?></h2>

  <?php if ($just_reset): ?>
  <div class="wp-inview-admin__notice wp-inview-admin__notice--success">
    <p><?php echo esc_html__('Settings have been restored to defaults.', 'wp-inview'); ?></p>
  </div>
  <?php endif; ?>
</div>

<div class="wp-inview-card">
  <div class="wp-inview-row wp-inview-card__content">
    <!-- UI LANGUAGE -->
    <div class="wp-inview-field">
      <div>
        <div class="wp-inview-field__label">
          <?php echo esc_html__('UI language', 'wp-inview'); ?>
        </div>
        <p class="wp-inview-field__help">
          <?php echo esc_html__('Override the plugin UI language. "Auto" follows your WordPress language setting.', 'wp-inview'); ?>
        </p>
      </div>
      <div class="wp-inview-inline">
        <select id="wp_inview_ui_language" class="wp-inview-admin__select"
          name="<?php echo esc_attr($option_key . '[ui][language]'); ?>">
          <option value="auto" <?php selected($lang, 'auto'); ?>>
            <?php echo esc_html__('Auto (WordPress)', 'wp-inview'); ?>
          </option>

          <option value="en" <?php selected($lang, 'en'); ?>>
            English
          </option>

          <option value="pl" <?php selected($lang, 'pl'); ?>>
            Polski
          </option>
        </select>
      </div>
    </div>

    <!-- EDITOR PANEL MODE -->
    <div class="wp-inview-field">
      <div>
        <div class="wp-inview-field__label">
          <?php echo esc_html__('Block editor panel', 'wp-inview'); ?>
        </div>
        <p class="wp-inview-field__help">
          <?php echo esc_html__('Choose how animation controls appear in the block editor. "Floating popup" opens a draggable window from the toolbar. "Sidebar" embeds controls in the block Inspector panel.', 'wp-inview'); ?>
        </p>
      </div>
      <div class="wp-inview-inline">
        <select id="wp_inview_ui_panel_mode" class="wp-inview-admin__select"
          name="<?php echo esc_attr($option_key . '[ui][editorPanelMode]'); ?>">
          <option value="popup" <?php selected($panel_mode, 'popup'); ?>>
            <?php echo esc_html__('Floating popup (toolbar button)', 'wp-inview'); ?>
          </option>
          <option value="sidebar" <?php selected($panel_mode, 'sidebar'); ?>>
            <?php echo esc_html__('Sidebar (Inspector panel)', 'wp-inview'); ?>
          </option>
        </select>
      </div>
    </div>

    <!-- LIST VIEW BADGES -->
    <div class="wp-inview-field">
      <div>
        <div class="wp-inview-field__label">
          <?php echo esc_html__('List View badges', 'wp-inview'); ?>
        </div>
        <p class="wp-inview-field__help">
          <?php echo esc_html__('Show the active preset name as a badge next to blocks in the List View sidebar.', 'wp-inview'); ?>
        </p>
      </div>
      <div class="wp-inview-inline">
        <label class="wp-inview-switch">
          <input type="hidden" name="<?php echo esc_attr($option_key . '[ui][showListViewBadges]'); ?>" value="0" />
          <input type="checkbox" id="wp_inview_show_lv_badges"
            name="<?php echo esc_attr($option_key . '[ui][showListViewBadges]'); ?>" value="1"
            <?php checked($show_lv_badges, true); ?> />
          <span class="wp-inview-switch__control" aria-hidden="true"></span>
          <span class="wp-inview-switch__text">
            <?php echo esc_html($show_lv_badges ? __('On', 'wp-inview') : __('Off', 'wp-inview')); ?>
          </span>
        </label>
      </div>
    </div>

    <!-- RESET -->
    <div class="wp-inview-field">
      <div>
        <div class="wp-inview-field__label">
          <?php echo esc_html__('Reset settings', 'wp-inview'); ?>
        </div>
        <p class="wp-inview-field__help">
          <?php echo esc_html__('Resets all plugin settings to defaults. This cannot be undone.', 'wp-inview'); ?>
        </p>
      </div>

      <div class="wp-inview-inline">
        <button type="button" class="wp-inview-btn wp-inview-btn--danger" data-wp-inview-reset-trigger="1"
          data-confirm="<?php echo esc_attr__('Are you sure you want to restore default settings? This cannot be undone.', 'wp-inview'); ?>">
          <?php echo esc_html__('Restore default settings', 'wp-inview'); ?>
        </button>
      </div>
    </div>
  </div>
</div>