<?php
	// includes/Admin/Views/tabs/page-transition/partials/variant-fade.php
	// v1: FADE variant settings (PRODUCTION READY)

	if (! defined('ABSPATH')) {
	exit;
	}

	$variant_key  = $variant_ctx['variant_key'] ?? 'fade';
	$v            = $variant_ctx['variant_data'] ?? [];
	$fields_ui    = $variant_ctx['fields_ui'] ?? [];
	$easing_rows  = $variant_ctx['easing_rows'] ?? [];
	$colors_rows  = $variant_ctx['colors_rows'] ?? [];
	$opacity_rows = $variant_ctx['opacity_rows'] ?? [];

	// Current values
	$variant_defaults = is_array($variant_ctx['variant_defaults'] ?? null) ? $variant_ctx['variant_defaults'] : [];
	$duration         = $v['duration'] ?? $variant_defaults['duration'] ?? 450;
	$easing           = $v['easing'] ?? $variant_defaults['easing'] ?? 'cubic-bezier(0.22, 1, 0.36, 1)';
	$overlayColor     = $v['overlayColor'] ?? $variant_defaults['overlayColor'] ?? '#ffffff';
	$overlayOpacity   = $v['overlayOpacity'] ?? $variant_defaults['overlayOpacity'] ?? 1.0;

	// UI definitions
	$duration_ui = $fields_ui['duration'] ?? [];
	$easing_ui   = $fields_ui['easing'] ?? [];
	$color_ui    = $fields_ui['overlayColor'] ?? [];
	$opacity_ui  = $fields_ui['overlayOpacity'] ?? [];

	// Copy strings from Schema
	$pt_copy       = is_array($variant_ctx['pt_copy'] ?? null) ? $variant_ctx['pt_copy'] : [];
	$lbl_custom    = (string) ($pt_copy['customLabel'] ?? __('Custom', 'wp-inview'));
	$lbl_c_easing  = (string) ($pt_copy['customEasing'] ?? __('Custom easing', 'wp-inview'));
	$lbl_c_e_help  = (string) ($pt_copy['customEasingHelp'] ?? __('CSS cubic-bezier, e.g. cubic-bezier(0.22, 1, 0.36, 1)', 'wp-inview'));
	$lbl_c_color   = (string) ($pt_copy['customColor'] ?? __('Custom color', 'wp-inview'));
	$lbl_c_opacity = (string) ($pt_copy['customOpacity'] ?? __('Custom opacity', 'wp-inview'));
	$lbl_c_op_help = (string) ($pt_copy['customOpacityHelp'] ?? __('Value between 0 (transparent) and 1 (solid).', 'wp-inview'));

	// Build easing chips (presets only — Custom… appended manually)
	$easing_chips = [];
	foreach ($easing_rows as $row) {
	if (! is_array($row) || ($row['type'] ?? '') !== 'preset') {
		continue;
	}
	if (empty($row['label']) || empty($row['value'])) {
		continue;
	}
	$easing_chips[] = ['label' => $row['label'], 'value' => $row['value']];
	}
	$easing_chips[] = ['label' => $lbl_custom . '…', 'value' => 'custom'];

	// Build color chips — skip 'custom', rendered manually with color picker
	$color_chips = [];
	foreach ($colors_rows as $row) {
	if (! is_array($row) || empty($row['label']) || empty($row['value'])) {
		continue;
	}
	if ($row['value'] === 'custom') {
		continue;
	}
	$color_chips[] = ['label' => $row['label'], 'value' => $row['value']];
	}

	// Build opacity chips
	$opacity_chips = [];
	foreach ($opacity_rows as $row) {
	if (! is_array($row) || empty($row['label']) || empty($row['value'])) {
		continue;
	}
	$opacity_chips[] = ['label' => $row['label'], 'value' => $row['value']];
	}

	// For color picker: needs valid 6-digit hex. Fallback to white.
	$preset_color_values = array_column($color_chips, 'value');
	$color_is_custom     = ! in_array($overlayColor, $preset_color_values, true);
	$color_picker_value  = preg_match('/^#[0-9a-fA-F]{6}$/', $overlayColor) ? $overlayColor : '#ffffff';
?>
<div class="wp-inview-row wp-inview-card__content">
  <!-- Duration -->
  <div class="wp-inview-field">
    <div>
      <div class="wp-inview-field__label">
        <?php echo esc_html($duration_ui['label'] ?? 'Duration'); ?>
      </div>
      <p class="wp-inview-field__help">
        <?php echo esc_html($duration_ui['help'] ?? 'Transition time in milliseconds. Recommended: 400–600ms'); ?>
      </p>
    </div>
    <div>
      <input type="number" <?php echo WP_InView_Admin_ViewHelpers::num_attrs($duration_ui); ?>
        name="<?php echo esc_attr("wp_inview_settings[pageTransition][variants][$variant_key][duration]"); ?>"
        value="<?php echo esc_attr((string) $duration); ?>" />
    </div>
  </div>

  <!-- Easing -->
  <div class="wp-inview-field">
    <div>
      <div class="wp-inview-field__label">
        <?php echo esc_html($easing_ui['label'] ?? 'Easing'); ?>
      </div>
      <p class="wp-inview-field__help">
        <?php echo esc_html($easing_ui['help'] ?? 'Animation timing function.'); ?>
      </p>
    </div>
    <div data-wp-inview-chip-group="easing-fade">
      <?php WP_InView_Admin_ViewHelpers::chips_list($easing_chips, 'data-value', ''); ?>

      <input type="hidden" data-wp-inview-value="1"
        name="<?php echo esc_attr("wp_inview_settings[pageTransition][variants][$variant_key][easing]"); ?>"
        value="<?php echo esc_attr($easing); ?>" />

      <div class="wp-inview-row wp-inview-hidden" data-wp-inview-custom-wrap="1">
        <div class="wp-inview-field">
          <div>
            <div class="wp-inview-field__label"><?php echo esc_html($lbl_c_easing); ?></div>
            <p class="wp-inview-field__help">
              <?php echo esc_html($lbl_c_e_help); ?>
            </p>
          </div>
          <div>
            <input type="text" data-wp-inview-custom-input="1" value="<?php echo esc_attr($easing); ?>"
              placeholder="<?php echo esc_attr($easing_ui['placeholder'] ?? 'cubic-bezier(0.22, 1, 0.36, 1)'); ?>"
              maxlength="<?php echo esc_attr((string) ($easing_ui['maxLen'] ?? 120)); ?>" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Overlay Color -->
  <div class="wp-inview-field">
    <div>
      <div class="wp-inview-field__label">
        <?php echo esc_html($color_ui['label'] ?? 'Overlay color'); ?>
      </div>
      <p class="wp-inview-field__help">
        <?php echo esc_html($color_ui['help'] ?? 'Color of the overlay during transition.'); ?>
      </p>
    </div>
    <div data-wp-inview-chip-group="color-fade">

      <div class="wp-inview-chips">
        <?php WP_InView_Admin_ViewHelpers::chips_list($color_chips, 'data-value', ''); ?>

        <!-- Custom chip — inline with presets, contains swatch preview -->
        <div class="wp-inview-chip <?php echo $color_is_custom ? 'is-active' : ''; ?>" data-value="custom"
          data-wp-inview-color-chip="1">
          <span class="wp-inview-chip__dot" aria-hidden="true"></span>
          <span class="wp-inview-chip__label"><?php echo esc_html($lbl_custom); ?></span>
          <span class="wp-inview-chip__color-swatch" style="background: <?php echo esc_attr($color_picker_value); ?>"
            aria-hidden="true"></span>
        </div>
      </div>

      <input type="hidden" data-wp-inview-value="1"
        name="<?php echo esc_attr("wp_inview_settings[pageTransition][variants][$variant_key][overlayColor]"); ?>"
        value="<?php echo esc_attr($overlayColor); ?>" />

      <!-- Color picker — shown when Custom chip is active -->
      <div class="wp-inview-row wp-inview-hidden" data-wp-inview-custom-wrap="1">
        <div class="wp-inview-field">
          <div>
            <div class="wp-inview-field__label"><?php echo esc_html($lbl_c_color); ?></div>
          </div>
          <div>
            <input type="color" data-wp-inview-custom-input="1" data-wp-inview-color-input="1"
              value="<?php echo esc_attr($color_picker_value); ?>" />
          </div>
        </div>
      </div>

    </div>
  </div>

  <!-- Overlay Opacity -->
  <div class="wp-inview-field">
    <div>
      <div class="wp-inview-field__label">
        <?php echo esc_html($opacity_ui['label'] ?? 'Overlay opacity'); ?>
      </div>
      <p class="wp-inview-field__help">
        <?php echo esc_html($opacity_ui['help'] ?? 'How solid the overlay appears. 1.0 = completely opaque.'); ?>
      </p>
    </div>
    <div data-wp-inview-chip-group="opacity-fade">
      <?php WP_InView_Admin_ViewHelpers::chips_list($opacity_chips, 'data-value', ''); ?>

      <input type="hidden" data-wp-inview-value="1"
        name="<?php echo esc_attr("wp_inview_settings[pageTransition][variants][$variant_key][overlayOpacity]"); ?>"
        value="<?php echo esc_attr((string) $overlayOpacity); ?>" />

      <div class="wp-inview-row wp-inview-hidden" data-wp-inview-custom-wrap="1">
        <div class="wp-inview-field">
          <div>
            <div class="wp-inview-field__label"><?php echo esc_html($lbl_c_opacity); ?></div>
            <p class="wp-inview-field__help"><?php echo esc_html($lbl_c_op_help); ?></p>
          </div>
          <div>
            <input type="number" <?php echo WP_InView_Admin_ViewHelpers::num_attrs($opacity_ui); ?>
              data-wp-inview-custom-input="1" value="<?php echo esc_attr((string) $overlayOpacity); ?>" />
          </div>
        </div>
      </div>
    </div>
  </div>
</div>