<?php
	// includes/Admin/Views/tabs/page-transition/partials/variant-curtain.php

	if (! defined('ABSPATH')) {
	exit;
	}

	$variant_key = $variant_ctx['variant_key'] ?? 'curtain';
	$v           = $variant_ctx['variant_data'] ?? [];
	$fields_ui   = $variant_ctx['fields_ui'] ?? [];
	$easing_rows = $variant_ctx['easing_rows'] ?? [];
	$colors_rows = $variant_ctx['colors_rows'] ?? [];

	// Current values
	$variant_defaults = is_array($variant_ctx['variant_defaults'] ?? null) ? $variant_ctx['variant_defaults'] : [];
	$duration         = $v['duration'] ?? $variant_defaults['duration'] ?? 600;
	$easing           = $v['easing'] ?? $variant_defaults['easing'] ?? 'cubic-bezier(0.22, 1, 0.36, 1)';
	$direction        = $v['direction'] ?? $variant_defaults['direction'] ?? 'left';
	$overlayColor     = $v['overlayColor'] ?? $variant_defaults['overlayColor'] ?? '#ffffff';
	$overlayOpacity   = $v['overlayOpacity'] ?? $variant_defaults['overlayOpacity'] ?? 1.0;

	// UI definitions
	$duration_ui  = $fields_ui['duration'] ?? [];
	$easing_ui    = $fields_ui['easing'] ?? [];
	$color_ui     = $fields_ui['overlayColor'] ?? [];
	$direction_ui = $fields_ui['direction'] ?? [];

	// Copy strings from Schema
	$pt_copy       = is_array($variant_ctx['pt_copy'] ?? null) ? $variant_ctx['pt_copy'] : [];
	$lbl_custom    = (string) ($pt_copy['customLabel'] ?? __('Custom', 'wp-inview'));
	$lbl_c_easing  = (string) ($pt_copy['customEasing'] ?? __('Custom easing', 'wp-inview'));
	$lbl_c_e_help  = (string) ($pt_copy['customEasingHelp'] ?? __('CSS cubic-bezier, e.g. cubic-bezier(0.22, 1, 0.36, 1)', 'wp-inview'));
	$lbl_c_color   = (string) ($pt_copy['customColor'] ?? __('Custom color', 'wp-inview'));
	$lbl_c_opacity = (string) ($pt_copy['customOpacity'] ?? __('Custom opacity', 'wp-inview'));
	$lbl_c_op_help = (string) ($pt_copy['customOpacityHelp'] ?? __('Value between 0 (transparent) and 1 (solid).', 'wp-inview'));

	// Direction chips
	// Direction chips from Schema (fields_ui['direction']['chips'])
	$direction_chips = is_array($direction_ui['chips'] ?? null) ? $direction_ui['chips'] : [
	['label' => __('Left', 'wp-inview'), 'value' => 'left'],
	['label' => __('Right', 'wp-inview'), 'value' => 'right'],
	['label' => __('Top', 'wp-inview'), 'value' => 'top'],
	['label' => __('Bottom', 'wp-inview'), 'value' => 'bottom'],
	];

	// Build easing chips (presets only — Custom… appended manually)
	$easing_chips = [];
	foreach ($easing_rows as $row) {
	if (! is_array($row) || ($row['type'] ?? '') !== 'preset') {
		continue;
	}
	if (empty($row['label']) || empty($row['value'])) {
		continue;
	}
	$easing_chips[] = ['label' => $row['label'], 'value' => $row['value']];
	}
	$easing_chips[] = ['label' => $lbl_custom . '…', 'value' => 'custom'];

	// Build color chips — skip 'custom', rendered manually with color picker
	$color_chips = [];
	foreach ($colors_rows as $row) {
	if (! is_array($row) || empty($row['label']) || empty($row['value'])) {
		continue;
	}
	if ($row['value'] === 'custom') {
		continue;
	}
	$color_chips[] = ['label' => $row['label'], 'value' => $row['value']];
	}

	// For color picker: needs valid 6-digit hex. Fallback to white.
	$preset_color_values = array_column($color_chips, 'value');
	$color_is_custom     = ! in_array($overlayColor, $preset_color_values, true);
	$color_picker_value  = preg_match('/^#[0-9a-fA-F]{6}$/', $overlayColor) ? $overlayColor : '#ffffff';
?>

<!-- Direction -->
<div class="wp-inview-field">
  <div>
    <div class="wp-inview-field__label">
      <?php echo esc_html($direction_ui['label'] ?? 'Enter from'); ?>
    </div>
    <p class="wp-inview-field__help">
      <?php echo esc_html((string) ($pt_copy['curtainDirectionHelp'] ?? __('The curtain slides in from this side.', 'wp-inview'))); ?>
    </p>
  </div>
  <div data-wp-inview-chip-group="curtain-direction">
    <?php WP_InView_Admin_ViewHelpers::chips_list($direction_chips, 'data-value', $direction); ?>
    <input type="hidden" data-wp-inview-value="1"
      name="<?php echo esc_attr("wp_inview_settings[pageTransition][variants][$variant_key][direction]"); ?>"
      value="<?php echo esc_attr($direction); ?>" />
  </div>
</div>
<div class="wp-inview-row wp-inview-card__content">
  <!-- Duration -->
  <div class="wp-inview-field">
    <div>
      <div class="wp-inview-field__label">
        <?php echo esc_html($duration_ui['label'] ?? 'Duration'); ?>
      </div>
      <p class="wp-inview-field__help">
        <?php echo esc_html($duration_ui['help'] ?? 'Transition time in milliseconds. Recommended: 500–700ms'); ?>
      </p>
    </div>
    <div>
      <input type="number" <?php echo WP_InView_Admin_ViewHelpers::num_attrs($duration_ui); ?>
        name="<?php echo esc_attr("wp_inview_settings[pageTransition][variants][$variant_key][duration]"); ?>"
        value="<?php echo esc_attr((string) $duration); ?>" />
    </div>
  </div>

  <!-- Easing -->
  <div class="wp-inview-field">
    <div>
      <div class="wp-inview-field__label">
        <?php echo esc_html($easing_ui['label'] ?? 'Easing'); ?>
      </div>
      <p class="wp-inview-field__help">
        <?php echo esc_html($easing_ui['help'] ?? 'Animation timing function.'); ?>
      </p>
    </div>
    <div data-wp-inview-chip-group="easing-curtain">
      <?php WP_InView_Admin_ViewHelpers::chips_list($easing_chips, 'data-value', ''); ?>

      <input type="hidden" data-wp-inview-value="1"
        name="<?php echo esc_attr("wp_inview_settings[pageTransition][variants][$variant_key][easing]"); ?>"
        value="<?php echo esc_attr($easing); ?>" />

      <div class="wp-inview-row wp-inview-hidden" data-wp-inview-custom-wrap="1">
        <div class="wp-inview-field">
          <div>
            <div class="wp-inview-field__label"><?php echo esc_html($lbl_c_easing); ?></div>
            <p class="wp-inview-field__help">
              <?php echo esc_html($lbl_c_e_help); ?>
            </p>
          </div>
          <div>
            <input type="text" data-wp-inview-custom-input="1" value="<?php echo esc_attr($easing); ?>"
              placeholder="<?php echo esc_attr($easing_ui['placeholder'] ?? 'cubic-bezier(0.22, 1, 0.36, 1)'); ?>"
              maxlength="<?php echo esc_attr((string) ($easing_ui['maxLen'] ?? 120)); ?>" />
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Curtain Color -->
  <div class="wp-inview-field">
    <div>
      <div class="wp-inview-field__label">
        <?php echo esc_html($color_ui['label'] ?? 'Curtain color'); ?>
      </div>
      <p class="wp-inview-field__help">
        <?php echo esc_html((string) ($pt_copy['curtainColorHelp'] ?? __('Color of the curtain overlay.', 'wp-inview'))); ?>
      </p>
    </div>
    <div data-wp-inview-chip-group="color-curtain">

      <div class="wp-inview-chips">
        <?php WP_InView_Admin_ViewHelpers::chips_list($color_chips, 'data-value', ''); ?>

        <!-- Custom chip with color swatch -->
        <div class="wp-inview-chip <?php echo $color_is_custom ? 'is-active' : ''; ?>" data-value="custom"
          data-wp-inview-color-chip="1">
          <span class="wp-inview-chip__dot" aria-hidden="true"></span>
          <span class="wp-inview-chip__label"><?php echo esc_html($lbl_custom); ?></span>
          <span class="wp-inview-chip__color-swatch" style="background: <?php echo esc_attr($color_picker_value); ?>"
            aria-hidden="true"></span>
        </div>
      </div>

      <input type="hidden" data-wp-inview-value="1"
        name="<?php echo esc_attr("wp_inview_settings[pageTransition][variants][$variant_key][overlayColor]"); ?>"
        value="<?php echo esc_attr($overlayColor); ?>" />

      <div class="wp-inview-row wp-inview-hidden" data-wp-inview-custom-wrap="1">
        <div class="wp-inview-field">
          <div>
            <div class="wp-inview-field__label"><?php echo esc_html($lbl_c_color); ?></div>
          </div>
          <div>
            <input type="color" data-wp-inview-custom-input="1" data-wp-inview-color-input="1"
              value="<?php echo esc_attr($color_picker_value); ?>" />
          </div>
        </div>
      </div>

    </div>
  </div>
</div>