<?php
	// includes/Admin/Views/tabs/page-transition/layout.php

	if (! defined('ABSPATH')) {
	exit;
	}

	$enabled       = $ctx['enabled'] ?? false;
	$activeVariant = $ctx['activeVariant'] ?? 'fade';
	$variants      = $ctx['variants'] ?? [];
	$registry      = $ctx['registry'] ?? [];
	$ui            = $ctx['ui'] ?? [];
	$fields_ui     = $ui['fields'] ?? [];

	$info = is_array($ui['info'] ?? null) ? $ui['info'] : [];

	$title            = (string) ($info['title'] ?? '');
	$desc             = (string) ($info['desc'] ?? '');
	$toggleSwitchHelp = (string) ($info['toggleSwitchHelp'] ?? '');
	$enableLabel      = (string) ($info['enableLabel'] ?? '');
	$activeLabel      = (string) ($info['activeLabel'] ?? '');
	$activeLabelHelp  = (string) ($info['activeLabelHelp'] ?? '');

	$available_variants   = [];
	$coming_soon_variants = [];
	foreach ($registry as $key => $def) {
	if ($def['available'] ?? false) {
		$available_variants[$key] = $def;
	} elseif ($def['comingSoon'] ?? false) {
		$coming_soon_variants[$key] = $def;
	}
	}

	$variant_chips = [];
	foreach ($available_variants as $key => $def) {
	$variant_chips[] = [
		'label' => $def['label'] ?? ucfirst($key),
		'value' => $key,
	];
	}

?>

<!-- Global Settings -->
<div class="wp-inview-card-wrap">

  <h2 class="wp-inview-card__title"><?php echo esc_html($title); ?> </h2>
  <p class="wp-inview-card__desc">
    <?php echo esc_html($desc); ?>
  </p>

  <!-- Enable Toggle -->
  <div class="wp-inview-row">
    <div class="wp-inview-field bg--transparent">
      <div>
        <div class="wp-inview-field__label"><?php echo esc_html($enableLabel); ?></div>
        <div class="wp-inview-field__help"><?php echo esc_html($toggleSwitchHelp); ?></div>
      </div>
      <div>
        <label class="wp-inview-switch">
          <input type="hidden" name="wp_inview_settings[pageTransition][enabled]" value="0" />
          <input type="checkbox" name="wp_inview_settings[pageTransition][enabled]" value="1"
            <?php checked($enabled, true); ?> />
          <span class="wp-inview-switch__control" aria-hidden="true"></span>
          <span class="wp-inview-switch__text"><?php echo esc_html($enabled
                                               			? (string) ($info['switchOn'] ?? __('On', 'wp-inview'))
                                               		: (string) ($info['switchOff'] ?? __('Off', 'wp-inview'))
                                               ); ?></span>
        </label>
      </div>
    </div>
  </div>

  <div class="wp-inview-row">
    <!-- Variant Selection -->
    <?php if (count($variant_chips) > 1): ?>
    <div class="wp-inview-field bg--transparent">
      <div>
        <div class="wp-inview-field__label"><?php echo esc_html($activeLabel); ?></div>
        <p class="wp-inview-field__help"><?php echo esc_html($activeLabelHelp); ?></p>
      </div>
      <div data-wp-inview-chip-group="variant" data-wp-inview-variant-switcher="1">
        <?php WP_InView_Admin_ViewHelpers::chips_list($variant_chips, 'data-value', $activeVariant); ?>
        <input type="hidden" data-wp-inview-value="1" name="wp_inview_settings[pageTransition][activeVariant]"
          value="<?php echo esc_attr($activeVariant); ?>" />
      </div>
    </div>
    <?php else: ?>
    <input type="hidden" name="wp_inview_settings[pageTransition][activeVariant]" value="fade" />
    <?php endif; ?>
  </div>
</div>

<!-- Variant Configuration Cards -->
<?php foreach ($available_variants as $variant_key => $variant_def):
	$variant_data = $variants[$variant_key] ?? [];
	$is_active    = ($variant_key === $activeVariant);
?>
<div class="wp-inview-card" data-variant="<?php echo esc_attr($variant_key); ?>">
  <div class="wp-inview-card__head"></div>
  <h3 class="wp-inview-card__title">
    <?php echo esc_html(($variant_def['label'] ?? ucfirst($variant_key))); ?>
  </h3>

  <?php if (! empty($variant_def['description'])): ?>
  <p class="wp-inview-card__desc">
    <?php echo esc_html($variant_def['description']); ?>
  </p>
  <?php endif; ?>

  <?php
  	// Variant-level defaults from registry (passed to partials as safety net).
  	// Partials must use $variant_defaults[$field] instead of hardcoded literals.
  	$variant_defaults = [];
  	if (is_array($variant_def['fields'] ?? null)) {
  		foreach ($variant_def['fields'] as $_fk => $_fd) {
  			$variant_defaults[$_fk] = $_fd['default'] ?? null;
  		}
  	}

  	$variant_ctx = [
  		'variant_key'      => $variant_key,
  		'variant_data'     => $variant_data,
  		'variant_def'      => $variant_def,
  		'variant_defaults' => $variant_defaults,
  		'fields_ui'        => $fields_ui,
  		'easing_rows'      => $ui['easing'] ?? [],
  		'colors_rows'      => $ui['colors'] ?? [],
  		'opacity_rows'     => $ui['opacity'] ?? [],
  		'pt_copy'          => $ui['copy'] ?? [],
  	];

  	$partial_path = WP_InView_Helpers::path("includes/Admin/Views/tabs/page-transition/partials/variant-{$variant_key}.php");

  	if (file_exists($partial_path)) {
  		require $partial_path;
  	}
  ?>
</div>
<?php endforeach; ?>