<?php

	declare (strict_types = 1);

	if (! defined('ABSPATH')) {
	exit;
	}

	/** @var array<string,mixed> $ctx */
	$ctx = isset($ctx) && is_array($ctx) ? $ctx : [];

	$selector = (string) ($ctx['selector'] ?? '');
	$limit    = (int) ($ctx['limit'] ?? 12);
	$step     = (int) ($ctx['step'] ?? 120);

	$ui_selector     = isset($ctx['ui_selector']) && is_array($ctx['ui_selector']) ? $ctx['ui_selector'] : [];
	$ui_limit        = isset($ctx['ui_limit']) && is_array($ctx['ui_limit']) ? $ctx['ui_limit'] : [];
	$ui_step         = isset($ctx['ui_step']) && is_array($ctx['ui_step']) ? $ctx['ui_step'] : [];
	$ui_cascade_info = isset($ctx['ui_cascade_info']) && is_array($ctx['ui_cascade_info']) ? $ctx['ui_cascade_info'] : [];
	$ui_cascade_copy = isset($ctx['ui_cascade_copy']) && is_array($ctx['ui_cascade_copy']) ? $ctx['ui_cascade_copy'] : [];
	$reset_url       = (string) ($ctx['reset_url'] ?? '');

	// UI strings from Schema
	$title       = (string) ($ui_cascade_info['title'] ?? __('Cascade', 'wp-inview'));
	$desc        = (string) ($ui_cascade_info['desc'] ?? '');
	$reset_label = (string) ($ui_cascade_copy['resetSettings'] ?? __('Reset settings to defaults', 'wp-inview'));

	// Field labels from Schema
	$selector_label       = (string) ($ui_selector['label'] ?? __('Child selector', 'wp-inview'));
	$selector_help        = (string) ($ui_selector['help'] ?? '');
	$selector_placeholder = (string) ($ui_selector['placeholder'] ?? 'img, li, .your-class');
	$selector_docs        = (string) ($ui_selector['docs'] ?? '');
	$limit_label          = (string) ($ui_limit['label'] ?? __('Limit', 'wp-inview'));
	$limit_help           = (string) ($ui_limit['help'] ?? '');
	$step_label           = (string) ($ui_step['label'] ?? __('Step', 'wp-inview'));
	$step_help            = (string) ($ui_step['help'] ?? '');
?>

<div class="wp-inview-card-wrap">

  <div class="wp-inview-card__head">
    <div>
      <h2 class="wp-inview-card__title"><?php echo esc_html($title); ?></h2>
      <?php if ($desc !== ''): ?>
      <p class="wp-inview-card__desc"><?php echo esc_html($desc); ?></p>
      <?php endif; ?>
    </div>
  </div>

  <div class="">
    <div class="wp-inview-row">

      <div class="wp-inview-field">
        <div>
          <?php WP_InView_Admin_ViewHelpers::label_help($selector_label, $selector_help); ?>
          <?php if ($selector_docs !== ''): ?>
          <a href="<?php echo esc_url($selector_docs); ?>" target="_blank" rel="noreferrer"
            class="wp-inview-field__docs-link">
            <?php echo esc_html(__('Learn more →', 'wp-inview')); ?>
          </a>
          <?php endif; ?>
        </div>
        <div>
          <input name="wp_inview_settings[animation][cascade][selector]" type="text"
            <?php echo WP_InView_Admin_ViewHelpers::text_attrs($ui_selector); ?>
            value="<?php echo esc_attr($selector); ?>" placeholder="<?php echo esc_attr($selector_placeholder); ?>" />
        </div>
      </div>

      <div class="wp-inview-field">
        <div>
          <?php WP_InView_Admin_ViewHelpers::label_help($limit_label, $limit_help); ?>
        </div>
        <div>
          <input name="wp_inview_settings[animation][cascade][limit]" type="number"
            <?php echo WP_InView_Admin_ViewHelpers::num_attrs($ui_limit); ?>
            value="<?php echo esc_attr((string) $limit); ?>" />
        </div>
      </div>

      <div class="wp-inview-field">
        <div>
          <?php WP_InView_Admin_ViewHelpers::label_help($step_label, $step_help); ?>
        </div>
        <div>
          <input name="wp_inview_settings[animation][cascade][step]" type="number"
            <?php echo WP_InView_Admin_ViewHelpers::num_attrs($ui_step); ?>
            value="<?php echo esc_attr((string) $step); ?>" />
        </div>
      </div>

    </div>
  </div>
</div>