<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {exit;}

/** @var array<string,mixed> $ctx */
/** @var array<string,mixed> $ui_info — set by layout.php from $ctx */
/** @var array<string,mixed> $settings — set by layout.php from $ctx */

$anim_settings = is_array($settings['animation']['settings'] ?? null)
	? $settings['animation']['settings']
	: [];
$anim_enabled = array_key_exists('enabled', $anim_settings)
	? (bool) $anim_settings['enabled']
	: true;

$title       = (string) ($ui_info['title']            ?? __('Animations', 'wp-inview'));
$desc        = (string) ($ui_info['desc']             ?? '');
$help        = (string) ($ui_info['toggleSwitchHelp'] ?? '');
$enable_lbl  = (string) ($ui_info['enableLabel']      ?? __('Enable animations', 'wp-inview'));
$switch_on   = (string) ($ui_info['switchOn']         ?? __('On',  'wp-inview'));
$switch_off  = (string) ($ui_info['switchOff']        ?? __('Off', 'wp-inview'));
?>

<header data-wp-inview-tabhead="1">
  <div class="wp-inview-card-wrap">
    <h2 class="wp-inview-card__title"><?php echo esc_html($title); ?></h2>
    <p class="wp-inview-card__desc"><?php echo esc_html($desc); ?></p>
    <div class="wp-inview-row">
      <div class="wp-inview-field bg--transparent">
        <div>
          <div class="wp-inview-field__label"><?php echo esc_html($enable_lbl); ?></div>
          <div class="wp-inview-field__help"><?php echo esc_html($help); ?></div>
        </div>
        <div>
          <label class="wp-inview-switch">
            <input type="hidden" name="wp_inview_settings[animation][settings][enabled]" value="0" />
            <input type="checkbox" name="wp_inview_settings[animation][settings][enabled]" value="1"
              <?php checked($anim_enabled, true); ?> />
            <span class="wp-inview-switch__control" aria-hidden="true"></span>
            <span class="wp-inview-switch__text"><?php echo esc_html($anim_enabled ? $switch_on : $switch_off); ?></span>
          </label>
        </div>
      </div>
    </div>
  </div>
</header>
