<?php
	// includes/Admin/Views/tabs/animation/partials/preset-zoom.php

	if (! defined('ABSPATH')) {exit;}

	/**
 * Expects (in scope from layout.php):
 * - $preset_key              string
 * - $zoomMode, $scaleFrom   string, float
 * - $rubberMode, $rubberAmp, $rubberBool
 * - $ui_fields               array
 * - $ui_copy                 array
 */

	$zoomModeUI = is_array($ui_fields['zoomMode'] ?? null) ? $ui_fields['zoomMode'] : [];
	$scaleUI    = is_array($ui_fields['scaleFrom'] ?? null) ? $ui_fields['scaleFrom'] : [];
	$rubberUI   = is_array($ui_fields['rubberMode'] ?? null) ? $ui_fields['rubberMode'] : [];

	$zoomModeLabel = (string) ($zoomModeUI['label'] ?? 'Zoom mode');
	$zoomModeHelp  = (string) ($zoomModeUI['help'] ?? 'Zoom in starts below 1, Zoom out starts above 1. Always ends at 1.');
	$scaleLabel    = (string) ($scaleUI['label'] ?? 'Scale start');
	$scaleHelp     = (string) ($scaleUI['help'] ?? ($ui_copy['scaleFromHint'] ?? 'Shown as percent. Stored as scale.'));
	$rubberLabel   = (string) ($rubberUI['label'] ?? 'Rubber');
	$rubberHelp    = (string) ($rubberUI['help'] ?? 'Adds a small overshoot at the end. Custom unlocks amplitude.');
	$rubberExample = (string) ($ui_copy['rubberAmpHint'] ?? 'Example: 3.5% equals 0.035.');
	$savedAsLabel  = (string) ($ui_copy['savedAs'] ?? 'Saved as');

	$zoomModeVal   = ($zoomMode === 'out') ? 'out' : 'in';
	$scaleVal      = ($scaleFrom > 0) ? (float) $scaleFrom : 0.95;
	$rubberModeVal = (string) $rubberMode;
	$rubberAmpVal  = (float) $rubberAmp;
	$rubberBoolVal = (bool) $rubberBool;

	// Zoom mode chips
	$zoomChips = is_array($zoomModeUI['chips'] ?? null) ? (array) $zoomModeUI['chips']
	: (is_array($zoomModeUI['options'] ?? null) ? (array) $zoomModeUI['options'] : []);
	if (! $zoomChips) {
	$zoomChips = [
		['label' => __('Zoom in', 'wp-inview'), 'value' => 'in'],
		['label' => __('Zoom out', 'wp-inview'), 'value' => 'out'],
	];
	}

	// Rubber chips
	$rubberChips = is_array($rubberUI['chips'] ?? null) ? (array) $rubberUI['chips']
	: (is_array($rubberUI['options'] ?? null) ? (array) $rubberUI['options'] : []);
	if (! $rubberChips) {
	$rubberChips = [
		['label' => __('Off', 'wp-inview'), 'value' => 'off'],
		['label' => __('Soft', 'wp-inview'), 'value' => 'soft'],
		['label' => __('Medium', 'wp-inview'), 'value' => 'medium'],
		['label' => __('Hard', 'wp-inview'), 'value' => 'hard'],
		['label' => __('Custom…', 'wp-inview'), 'value' => 'custom'],
	];
	}

	// Scale percent limits from schema modes
	$pct_min  = 50;
	$pct_max  = 150;
	$pct_step = 1;
	$modes    = is_array($scaleUI['modes'] ?? null) ? (array) $scaleUI['modes'] : [];
	if ($modes) {
	$modeDef = is_array($modes[$zoomModeVal] ?? null) ? (array) $modes[$zoomModeVal] : [];
	$minS    = isset($modeDef['min']) ? (float) $modeDef['min'] : null;
	$maxS    = isset($modeDef['max']) ? (float) $modeDef['max'] : null;
	if ($minS !== null && $maxS !== null && $minS > 0 && $maxS > 0) {
		$pct_min = (int) round($minS * 100);
		$pct_max = (int) round($maxS * 100);
	}
	}
	if (isset($scaleUI['step']) && (float) $scaleUI['step'] > 0) {
	$pct_step = max(1, (int) round((float) $scaleUI['step'] * 100));
	}
?>

<div class="wp-inview-field">
  <div>
    <div class="wp-inview-field__label"><?php echo esc_html($zoomModeLabel); ?></div>
    <p class="wp-inview-field__help"><?php echo esc_html($zoomModeHelp); ?></p>
  </div>
  <div>
    <div data-wp-inview-chip-group="zoomMode">
      <?php WP_InView_Admin_ViewHelpers::hidden_value_input(
      		"wp_inview_settings[animation][presets][$preset_key][zoomMode]", $zoomModeVal
      ); ?>
      <select class="wp-inview-hidden" data-wp-inview-zoom-mode="1">
        <?php foreach ($zoomChips as $opt):
        		if (! is_array($opt)) {continue;}
        		$val = (string) ($opt['value'] ?? '');
        		$lbl = (string) ($opt['label'] ?? '');
        		if ($val === '' || $lbl === '') {continue;}
        ?>
        <option value="<?php echo esc_attr($val); ?>" <?php echo selected($zoomModeVal, $val, false); ?>>
          <?php echo esc_html($lbl); ?>
        </option>
        <?php endforeach; ?>
      </select>
      <?php WP_InView_Admin_ViewHelpers::chips_list($zoomChips, 'data-value', $zoomModeVal); ?>
    </div>
  </div>
</div>

<div class="wp-inview-field">
  <div>
    <div class="wp-inview-field__label"><?php echo esc_html($scaleLabel); ?></div>
    <p class="wp-inview-field__help"><?php echo esc_html($scaleHelp); ?></p>
  </div>
  <div class="wp-inview-inline" data-wp-inview-scale-wrap="1">
    <input type="hidden" data-wp-inview-scale-value="1"
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][scaleFrom]"); ?>"
      value="<?php echo esc_attr((string) $scaleVal); ?>" />
    <input type="number" data-wp-inview-scale-percent="1"
      value="<?php echo esc_attr((string) round($scaleVal * 100)); ?>" min="<?php echo esc_attr((string) $pct_min); ?>"
      max="<?php echo esc_attr((string) $pct_max); ?>" step="<?php echo esc_attr((string) $pct_step); ?>" />
    <span class="wp-inview-suffix">%</span>
    <span class="wp-inview-field__help">
      <?php echo esc_html($savedAsLabel); ?>
      <code data-wp-inview-scale-readout="1"><?php echo esc_html(number_format($scaleVal, 2, '.', '')); ?></code>
    </span>
  </div>
</div>

<div class="wp-inview-field">
  <div>
    <div class="wp-inview-field__label"><?php echo esc_html($rubberLabel); ?></div>
    <p class="wp-inview-field__help"><?php echo esc_html($rubberHelp); ?></p>
  </div>
  <div data-wp-inview-chip-group="rubber">
    <?php WP_InView_Admin_ViewHelpers::hidden_value_input(
    		"wp_inview_settings[animation][presets][$preset_key][rubberMode]", $rubberModeVal
    ); ?>
    <input type="hidden" data-wp-inview-rubber-amp="1"
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][rubberAmp]"); ?>"
      value="<?php echo esc_attr((string) $rubberAmpVal); ?>" />
    <input type="hidden" data-wp-inview-rubber-bool="1"
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][rubber]"); ?>"
      value="<?php echo esc_attr($rubberBoolVal ? '1' : '0'); ?>" />
    <?php WP_InView_Admin_ViewHelpers::chips_list($rubberChips, 'data-key', $rubberModeVal); ?>
    <div class="wp-inview-inline wp-inview-hidden" data-wp-inview-custom-wrap="1">
      <input type="number" data-wp-inview-rubber-amp-percent="1"
        value="<?php echo esc_attr((string) (round($rubberAmpVal * 1000) / 10)); ?>" min="0" max="10" step="0.5" />
      <span class="wp-inview-suffix">%</span>
      <span class="wp-inview-field__help"><?php echo esc_html($rubberExample); ?></span>
    </div>
  </div>
</div>