<?php
	// includes/Admin/Views/tabs/animation/partials/preset-once.php

	if (! defined('ABSPATH')) {exit;}

	/**
 * Expects (in scope from layout.php):
 * - $preset_key  string
 * - $once        bool
 * - $ui_fields   array
 */

	$once_ui    = is_array($ui_fields['once'] ?? null) ? $ui_fields['once'] : [];
	$label      = (string) ($once_ui['label'] ?? __('Animate once', 'wp-inview'));
	$help       = (string) ($once_ui['help'] ?? __('If enabled, the animation runs only the first time the element enters the viewport.', 'wp-inview'));
	$switch_on  = (string) ($ui_copy['switchOn'] ?? __('On', 'wp-inview'));
	$switch_off = (string) ($ui_copy['switchOff'] ?? __('Off', 'wp-inview'));

	$once_bool = ! empty($once);
	$name      = "wp_inview_settings[animation][presets][$preset_key][once]";
	$id        = "wp-inview-{$preset_key}-once";
?>
<div>

  <div class="wp-inview-field">
    <div>
      <div class="wp-inview-field__label"><?php echo esc_html($label); ?></div>
      <p class="wp-inview-field__help"><?php echo esc_html($help); ?></p>
    </div>
    <div>
      <label class="wp-inview-switch" for="<?php echo esc_attr($id); ?>">
        <input type="hidden" name="<?php echo esc_attr($name); ?>" value="0" />
        <input id="<?php echo esc_attr($id); ?>" type="checkbox" name="<?php echo esc_attr($name); ?>" value="1"
          <?php checked($once_bool, true); ?> />
        <span class="wp-inview-switch__control" aria-hidden="true"></span>
        <span class="wp-inview-switch__text"><?php echo esc_html($once_bool ? $switch_on : $switch_off); ?></span>
      </label>
    </div>
  </div>
</div>