<?php
	// includes/Admin/Views/tabs/animation/partials/preset-move.php

	if (! defined('ABSPATH')) {exit;}

	/**
 * Expects (in scope from layout.php):
 * - $preset_key  string
 * - $direction   string
 * - $distance    int
 * - $ui_fields   array
 */

	$dir_ui = is_array($ui_fields['direction'] ?? null) ? $ui_fields['direction'] : [];
	$dst_ui = is_array($ui_fields['distance'] ?? null) ? $ui_fields['distance'] : [];

	$dir_label = (string) ($dir_ui['label'] ?? 'Direction');
	$dir_help  = (string) ($dir_ui['help'] ?? '');
	$dst_label = (string) ($dst_ui['label'] ?? 'Distance');
	$dst_help  = (string) ($dst_ui['help'] ?? '');
	$dst_unit  = (string) ($dst_ui['unit'] ?? 'px');

	$direction_val = ($direction !== '') ? $direction : 'up';
	$distance_val  = (string) $distance;

	$direction_chips = [];
	if (is_array($dir_ui['chips'] ?? null)) {
	foreach ($dir_ui['chips'] as $chip) {
		if (! is_array($chip)) {continue;}
		$lbl = (string) ($chip['label'] ?? '');
		$val = (string) ($chip['value'] ?? '');
		if ($lbl === '' || $val === '') {continue;}
		$direction_chips[] = ['label' => $lbl, 'value' => $val];
	}
	}
	if (! $direction_chips) {
	$direction_chips = [
		['label' => __('Up', 'wp-inview'), 'value' => 'up'],
		['label' => __('Down', 'wp-inview'), 'value' => 'down'],
		['label' => __('Left', 'wp-inview'), 'value' => 'left'],
		['label' => __('Right', 'wp-inview'), 'value' => 'right'],
	];
	}
?>

<!-- Direction -->
<div class="wp-inview-field">
  <div>
    <div class="wp-inview-field__label"><?php echo esc_html($dir_label); ?></div>
    <?php if ($dir_help !== ''): ?>
    <p class="wp-inview-field__help"><?php echo esc_html($dir_help); ?></p>
    <?php endif; ?>
  </div>
  <div data-wp-inview-chip-group="direction">
    <?php WP_InView_Admin_ViewHelpers::chips_list($direction_chips, 'data-value', $direction_val); ?>
    <input type="hidden" data-wp-inview-value="1"
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][direction]"); ?>"
      value="<?php echo esc_attr($direction_val); ?>" />
  </div>
</div>

<!-- Distance -->
<div class="wp-inview-field">
  <div>
    <div class="wp-inview-field__label"><?php echo esc_html($dst_label); ?></div>
    <?php if ($dst_help !== ''): ?>
    <p class="wp-inview-field__help"><?php echo esc_html($dst_help); ?></p>
    <?php endif; ?>
  </div>
  <div class="wp-inview-inline">
    <input type="number" <?php echo WP_InView_Admin_ViewHelpers::num_attrs($dst_ui); ?>
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][distance]"); ?>"
      value="<?php echo esc_attr($distance_val); ?>" />
    <span class="wp-inview-suffix"><?php echo esc_html($dst_unit); ?></span>
  </div>
</div>