<?php

	if (! defined('ABSPATH')) {exit;}

	/**
 * Expects (in scope from layout.php):
 * - $preset_key                    string
 * - $maskVariant, $maskDirection   string
 * - $maskFeather, $maskInset       int
 * - $ui_fields                     array
 */

	$ui_maskVariant   = is_array($ui_fields['maskVariant'] ?? null) ? $ui_fields['maskVariant'] : [];
	$ui_maskDirection = is_array($ui_fields['maskDirection'] ?? null) ? $ui_fields['maskDirection'] : [];
	$ui_maskFeather   = is_array($ui_fields['maskFeather'] ?? null) ? $ui_fields['maskFeather'] : [];
	$ui_maskInset     = is_array($ui_fields['maskInset'] ?? null) ? $ui_fields['maskInset'] : [];

	// Variant chips from Schema (not hardcoded)
	$variant_chips = is_array($ui_maskVariant['chips'] ?? null) ? $ui_maskVariant['chips'] : [
	['label' => __('Wipe', 'wp-inview'), 'value' => 'wipe'],
	];

	// Direction chips from Schema — no more ucwords() dynamic generation
	$dir_chips = is_array($ui_maskDirection['chips'] ?? null) ? $ui_maskDirection['chips'] : [
	['label' => __('Up', 'wp-inview'), 'value' => 'up'],
	['label' => __('Down', 'wp-inview'), 'value' => 'down'],
	['label' => __('Left', 'wp-inview'), 'value' => 'left'],
	['label' => __('Right', 'wp-inview'), 'value' => 'right'],
	['label' => __('Horizontal', 'wp-inview'), 'value' => 'horizontal'],
	['label' => __('Vertical', 'wp-inview'), 'value' => 'vertical'],
	];

	// UI labels from Schema
	$variant_label   = (string) ($ui_maskVariant['label'] ?? __('Mask variant', 'wp-inview'));
	$variant_help    = (string) ($ui_maskVariant['help'] ?? __('Wipe reveals content in one direction. Radial reveals from center.', 'wp-inview'));
	$direction_label = (string) ($ui_maskDirection['label'] ?? __('Direction', 'wp-inview'));
	$direction_help  = (string) ($ui_maskDirection['help'] ?? __('Reveal direction for wipe.', 'wp-inview'));
	$feather_label   = (string) ($ui_maskFeather['label'] ?? __('Feather', 'wp-inview'));
	$feather_help    = (string) ($ui_maskFeather['help'] ?? __('Softness of the mask edge in pixels.', 'wp-inview'));
	$inset_label     = (string) ($ui_maskInset['label'] ?? __('Inset', 'wp-inview'));
	$inset_help      = (string) ($ui_maskInset['help'] ?? __('How much is hidden at start, in percent.', 'wp-inview'));

	$name_variant = "wp_inview_settings[animation][presets][$preset_key][maskVariant]";
?>

<div class="wp-inview-row">

  <!-- don't remove this code. Commented on purpose // 1.01+ feature -->
  <!--<div class="wp-inview-field">
    <div>
      <?php WP_InView_Admin_ViewHelpers::label_help($variant_label, $variant_help); ?>
    </div>
    <div class="wp-inview-chips" role="radiogroup" aria-label="<?php echo esc_attr($variant_label); ?>">
      <?php foreach ($variant_chips as $chip):
      		$chip_val   = (string) ($chip['value'] ?? '');
      		$chip_label = (string) ($chip['label'] ?? $chip_val);
      ?>
      <label class="wp-inview-chip">
        <input type="radio" name="<?php echo esc_attr($name_variant); ?>"
          value="<?php echo esc_attr($chip_val); ?>"
          <?php checked($maskVariant, $chip_val); ?> />
        <span><?php echo esc_html($chip_label); ?></span>
      </label>
      <?php endforeach; ?>
    </div>
  </div>-->

  <div class="wp-inview-field">
    <div>
      <?php WP_InView_Admin_ViewHelpers::label_help($direction_label, $direction_help); ?>
    </div>
    <div data-wp-inview-chip-group="maskDirection">
      <?php WP_InView_Admin_ViewHelpers::chips_list($dir_chips, 'data-value', $maskDirection); ?>
      <input type="hidden" data-wp-inview-value="1"
        name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][maskDirection]"); ?>"
        value="<?php echo esc_attr($maskDirection); ?>" />
    </div>
  </div>

  <div class="wp-inview-field">
    <div>
      <?php WP_InView_Admin_ViewHelpers::label_help($feather_label, $feather_help); ?>
    </div>
    <div>
      <input type="number"
        name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][maskFeather]"); ?>"
        <?php echo WP_InView_Admin_ViewHelpers::num_attrs($ui_maskFeather); ?>
        value="<?php echo esc_attr((string) $maskFeather); ?>" />
    </div>
  </div>

  <div class="wp-inview-field">
    <div>
      <?php WP_InView_Admin_ViewHelpers::label_help($inset_label, $inset_help); ?>
    </div>
    <div>
      <input type="number"
        name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][maskInset]"); ?>"
        <?php echo WP_InView_Admin_ViewHelpers::num_attrs($ui_maskInset); ?>
        value="<?php echo esc_attr((string) $maskInset); ?>" />
    </div>
  </div>

</div>