<?php
	// includes/Admin/Views/tabs/animation/partials/preset-common.php

	if (! defined('ABSPATH')) {exit;}

	/**
 * Common preset fields: opacity, duration, delay, easing, trigger.
 *
 * Expects (in scope from layout.php):
 * - $preset_key
 * - $p               array   (raw saved settings for this preset)
 * - $opacityFrom, $duration, $delay, $easing, $threshold, $rootMargin
 * - $triggerPreset   string  (already resolved by layout.php)
 * - $ui_fields       array
 * - $easing_rows     array
 * - $trigger_rows    array
 * - $opacity_chips   array
 */

	// ── UI field definitions ─────────────────────────────────────────────────────
	$op_ui  = is_array($ui_fields['opacityFrom'] ?? null) ? $ui_fields['opacityFrom'] : [];
	$du_ui  = is_array($ui_fields['duration'] ?? null) ? $ui_fields['duration'] : [];
	$de_ui  = is_array($ui_fields['delay'] ?? null) ? $ui_fields['delay'] : [];
	$ea_ui  = is_array($ui_fields['easing'] ?? null) ? $ui_fields['easing'] : [];
	$thr_ui = is_array($ui_fields['threshold'] ?? null) ? $ui_fields['threshold'] : [];
	$rm_ui  = is_array($ui_fields['rootMargin'] ?? null) ? $ui_fields['rootMargin'] : [];
	$tp_ui  = is_array($ui_fields['triggerPreset'] ?? null) ? $ui_fields['triggerPreset'] : [];

	// ── Labels ───────────────────────────────────────────────────────────────────
	$op_label  = (string) ($op_ui['label'] ?? 'Opacity from');
	$op_help   = (string) ($op_ui['help'] ?? '');
	$du_label  = (string) ($du_ui['label'] ?? 'Duration');
	$du_help   = (string) ($du_ui['help'] ?? '');
	$de_label  = (string) ($de_ui['label'] ?? 'Delay');
	$de_help   = (string) ($de_ui['help'] ?? '');
	$ea_label  = (string) ($ea_ui['label'] ?? 'Easing');
	$ea_help   = (string) ($ea_ui['help'] ?? '');
	$thr_label = (string) ($thr_ui['label'] ?? 'Trigger threshold');
	$thr_help  = (string) ($thr_ui['help'] ?? 'How much needs to be visible (0–1).');
	$rm_label  = (string) ($rm_ui['label'] ?? 'Root margin');
	$rm_help   = (string) ($rm_ui['help'] ?? 'Adjusts how early the animation can trigger.');
	$rm_ex     = (string) ($rm_ui['example'] ?? '0px 0px -4% 0px');

	// ── Render helper ────────────────────────────────────────────────────────────
$render_label_help = static function (string $label, string $help): void {?>
<div class="wp-inview-field__label"><?php echo esc_html($label); ?></div>
<?php if ($help !== ''): ?>
<p class="wp-inview-field__help"><?php echo esc_html($help); ?></p>
<?php endif;};

	// ── Opacity chips ────────────────────────────────────────────────────────────
	$opacity_chips_local = $opacity_chips ?: [
	['label' => __('Invisible start', 'wp-inview'), 'value' => '0'],
	['label' => __('Custom…', 'wp-inview'), 'value' => 'custom'],
	];

	// ── Easing chips ─────────────────────────────────────────────────────────────
	$easing_chips = [];
	foreach ($easing_rows as $row) {
	if (! is_array($row) || ($row['type'] ?? '') !== 'preset') {continue;}
	$lbl = (string) ($row['label'] ?? '');
	$val = (string) ($row['value'] ?? '');
	if ($lbl === '' || $val === '') {continue;}
	$easing_chips[] = ['label' => $lbl, 'value' => $val];
	}
	$easing_chips[] = ['label' => __('Custom…', 'wp-inview'), 'value' => 'custom'];

	// ── Trigger chips ─────────────────────────────────────────────────────────────
	$trigger_chips = [];
	foreach ($trigger_rows as $row) {
	if (! is_array($row)) {continue;}
	$key = (string) ($row['key'] ?? '');
	$lbl = (string) ($row['label'] ?? '');
	if ($key === '' || $lbl === '') {continue;}
	$trigger_chips[] = ['label' => $lbl, 'value' => $key];
	}
	$has_custom = (bool) array_filter($trigger_chips, fn($c) => ($c['value'] ?? '') === 'custom');
	if (! $has_custom) {
	$trigger_chips[] = ['label' => __('Custom…', 'wp-inview'), 'value' => 'custom'];
	}

	$easing_val = ($easing !== '') ? $easing : (string) ($ea_ui['placeholder'] ?? 'cubic-bezier(0.22, 1, 0.36, 1)');
?>

<!-- Duration + Delay -->

<div class="wp-inview-field">
  <div><?php $render_label_help($du_label, $du_help); ?></div>
  <div>
    <input type="number" <?php echo WP_InView_Admin_ViewHelpers::num_attrs($du_ui); ?>
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][duration]"); ?>"
      value="<?php echo esc_attr((string) $duration); ?>" />
  </div>
</div>
<div class="wp-inview-field">
  <div><?php $render_label_help($de_label, $de_help); ?></div>
  <div>
    <input type="number" <?php echo WP_InView_Admin_ViewHelpers::num_attrs($de_ui); ?>
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][delay]"); ?>"
      value="<?php echo esc_attr((string) $delay); ?>" />
  </div>
</div>

<!-- Opacity -->
<div class="wp-inview-field">
  <div><?php $render_label_help($op_label, $op_help); ?></div>
  <div data-wp-inview-chip-group="opacity">
    <?php WP_InView_Admin_ViewHelpers::chips_list($opacity_chips_local, 'data-value', ''); ?>
    <input type="hidden" data-wp-inview-value="1"
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][opacityFrom]"); ?>"
      value="<?php echo esc_attr((string) $opacityFrom); ?>" />
    <div class="wp-inview-row wp-inview-hidden" data-wp-inview-custom-wrap="1">
      <div class="wp-inview-field">
        <div><?php $render_label_help($op_label, $op_help); ?></div>
        <div>
          <input type="number" <?php echo WP_InView_Admin_ViewHelpers::num_attrs($op_ui); ?>
            data-wp-inview-custom-input="1" value="<?php echo esc_attr((string) $opacityFrom); ?>" />
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Easing -->
<div class="wp-inview-field">
  <div><?php $render_label_help($ea_label, $ea_help); ?></div>
  <div data-wp-inview-chip-group="easing">
    <?php WP_InView_Admin_ViewHelpers::chips_list($easing_chips, 'data-value', ''); ?>
    <input type="hidden" data-wp-inview-value="1"
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][easing]"); ?>"
      value="<?php echo esc_attr($easing_val); ?>" />
    <div class="wp-inview-row wp-inview-hidden" data-wp-inview-custom-wrap="1">
      <div class="wp-inview-field">
        <div><?php $render_label_help($ea_label, $ea_help); ?></div>
        <div>
          <input type="text" <?php echo WP_InView_Admin_ViewHelpers::text_attrs($ea_ui); ?>
            data-wp-inview-custom-input="1" value="<?php echo esc_attr($easing_val); ?>"
            placeholder="<?php echo esc_attr((string) ($ea_ui['placeholder'] ?? 'cubic-bezier(0.22, 1, 0.36, 1)')); ?>" />
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Trigger -->
<div class="wp-inview-field">
  <div>
    <div class="wp-inview-field__label"><?php echo esc_html((string) ($tp_ui['label'] ?? 'Trigger preset')); ?></div>
    <p class="wp-inview-field__help">
      <?php echo esc_html((string) ($tp_ui['help'] ?? 'Pick a trigger profile. Custom lets you set threshold and root margin manually.')); ?>
    </p>
  </div>
  <div data-wp-inview-chip-group="trigger">
    <input type="hidden" data-wp-inview-trigger-preset="1"
      name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][triggerPreset]"); ?>"
      value="<?php echo esc_attr($triggerPreset); ?>" />
    <?php WP_InView_Admin_ViewHelpers::chips_list($trigger_chips, 'data-key', ''); ?>
    <div class="wp-inview-row wp-inview-hidden" data-wp-inview-custom-wrap="1">
      <div class="wp-inview-field">
        <div>
          <div class="wp-inview-field__label"><?php echo esc_html($thr_label); ?></div>
          <p class="wp-inview-field__help"><?php echo esc_html($thr_help); ?></p>
        </div>
        <div>
          <input type="number" <?php echo WP_InView_Admin_ViewHelpers::num_attrs($thr_ui); ?>
            data-wp-inview-trigger-threshold="1"
            name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][threshold]"); ?>"
            value="<?php echo esc_attr((string) $threshold); ?>" />
        </div>
      </div>
      <div class="wp-inview-field">
        <div>
          <div class="wp-inview-field__label"><?php echo esc_html($rm_label); ?></div>
          <p class="wp-inview-field__help">
            <?php echo esc_html($rm_help); ?>
            <span>Example: <code><?php echo esc_html($rm_ex); ?></code>.</span>
          </p>
        </div>
        <div>
          <input type="text" <?php echo WP_InView_Admin_ViewHelpers::text_attrs($rm_ui); ?>
            data-wp-inview-trigger-rootMargin="1"
            name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][rootMargin]"); ?>"
            value="<?php echo esc_attr((string) $rootMargin); ?>" placeholder="<?php echo esc_attr($rm_ex); ?>" />
        </div>
      </div>
    </div>
  </div>
</div>