<?php
	// includes/Admin/Views/tabs/animation/partials/preset-card-open.php

	if (! defined('ABSPATH')) {exit;}

	/**
 * Expects (in scope from layout.php):
 * - $preset_key  string
 * - $title       string
 * - $desc        string
 * - $preset_card_desc_tpl  string
 */

	$card_desc = ($desc !== '')
	? $desc
	: str_replace('{preset}', $preset_key, $preset_card_desc_tpl);
?>
<div class="wp-inview-card" data-wp-inview-card="1" data-wp-inview-preset="<?php echo esc_attr($preset_key); ?>">
  <div class="wp-inview-card__head">
    <div>
      <h3 class="wp-inview-card__title"><?php echo esc_html($title); ?></h3>
      <p class="wp-inview-card__desc">
        <?php echo esc_html($card_desc); ?>
        <code><?php echo esc_html($preset_key); ?></code>
      </p>
    </div>
  </div>

  <div class="wp-inview-row wp-inview-card__content">