<?php
	// includes/Admin/Views/tabs/animation/partials/preset-blur.php

	if (! defined('ABSPATH')) {exit;}

	/**
 * Expects (in scope from layout.php):
 * - $preset_key  string
 * - $blurFrom    float
 * - $ui_fields   array
 */

	$ui_blurFrom = is_array($ui_fields['blurFrom'] ?? null) ? $ui_fields['blurFrom'] : [];
?>

<div class="wp-inview-row">
  <div class="wp-inview-field">
    <div>
      <?php WP_InView_Admin_ViewHelpers::label_help(
        (string) ($ui_blurFrom['label'] ?? __('Blur from', 'wp-inview')),
        (string) ($ui_blurFrom['help']  ?? __('Start blur strength (px). Ends at 0.', 'wp-inview'))
      ); ?>
    </div>
    <div>
      <input type="number"
        name="<?php echo esc_attr("wp_inview_settings[animation][presets][$preset_key][blurFrom]"); ?>"
        <?php echo WP_InView_Admin_ViewHelpers::num_attrs($ui_blurFrom); ?>
        value="<?php echo esc_attr((string) $blurFrom); ?>" />
    </div>
  </div>
</div>