<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

/**
 * Animation tab layout.
 *
 * Receives a fully-prepared $ctx from WP_InView_Admin_Tab_Animation::render().
 * This file must NOT call WP_InView_Schema::* — all UI data arrives via $ctx.
 *
 * @var array<string,mixed> $ctx
 */

$ctx = isset($ctx) && is_array($ctx) ? $ctx : [];

// ── Unpack ctx ───────────────────────────────────────────────────────────────

/** @var string[] $keys */
$keys         = is_array($ctx['keys'] ?? null) ? $ctx['keys'] : [];
$presets      = is_array($ctx['presets'] ?? null) ? $ctx['presets'] : [];
$defaults_all = is_array($ctx['defaults_all'] ?? null) ? $ctx['defaults_all'] : [];
$registry     = is_array($ctx['registry'] ?? null) ? $ctx['registry'] : [];
$settings     = is_array($ctx['settings'] ?? null) ? $ctx['settings'] : [];

$ui_fields            = is_array($ctx['ui_fields'] ?? null) ? $ctx['ui_fields'] : [];
$ui_copy              = is_array($ctx['ui_copy'] ?? null) ? $ctx['ui_copy'] : [];
$ui_info              = is_array($ctx['ui_info'] ?? null) ? $ctx['ui_info'] : [];
$easing_rows          = is_array($ctx['easing_rows'] ?? null) ? $ctx['easing_rows'] : [];
$trigger_rows         = is_array($ctx['trigger_rows'] ?? null) ? $ctx['trigger_rows'] : [];
$opacity_chips        = is_array($ctx['opacity_chips'] ?? null) ? $ctx['opacity_chips'] : [];
$preset_card_desc_tpl = (string) ($ctx['preset_card_desc_tpl'] ?? 'Applies to blocks using preset {preset}.');

$partials_dir = (string) ($ctx['view_base'] ?? '') . 'partials/';

// ── Tab header ───────────────────────────────────────────────────────────────

$__p = $partials_dir . 'tab-header.php';
if (file_exists($__p)) {require $__p;}

// ── Preset cards ─────────────────────────────────────────────────────────────

foreach ($keys as $preset_key_raw) {
	$preset_key = is_string($preset_key_raw) ? $preset_key_raw : (string) $preset_key_raw;
	if ($preset_key === '') {continue;}

	$p               = is_array($presets[$preset_key] ?? null) ? $presets[$preset_key] : [];
	$presetDef       = is_array($registry[$preset_key] ?? null) ? $registry[$preset_key] : [];
	$defaults_preset = is_array($defaults_all[$preset_key] ?? null) ? $defaults_all[$preset_key] : [];

	// ── Preset meta ─────────────────────────────────────────────────────────
	$title = (isset($presetDef['label']) && $presetDef['label'] !== '')
		? (string) $presetDef['label']
		: strtoupper($preset_key);

	$desc = (string) ($presetDef['description'] ?? '');

	// ── Resolve all field values (saved → default) ───────────────────────────
	$once = array_key_exists('once', $p)
		? (bool) $p['once']
		: (bool) ($defaults_preset['once'] ?? true);

	$triggerPreset = array_key_exists('triggerPreset', $p)
		? (string) $p['triggerPreset']
		: (string) ($defaults_preset['triggerPreset'] ?? 'natural');
	if ($triggerPreset === '') {$triggerPreset = 'natural';}

	$opacityFrom = array_key_exists('opacityFrom', $p)
		? (string) $p['opacityFrom']
		: (string) ($defaults_preset['opacityFrom'] ?? '0');

	$duration = array_key_exists('duration', $p)
		? (int) $p['duration']
		: (int) ($defaults_preset['duration'] ?? 650);

	$delay = array_key_exists('delay', $p)
		? (int) $p['delay']
		: (int) ($defaults_preset['delay'] ?? 0);

	$easing = array_key_exists('easing', $p)
		? (string) $p['easing']
		: (string) ($defaults_preset['easing'] ?? 'cubic-bezier(0.22, 1, 0.36, 1)');

	$threshold = array_key_exists('threshold', $p)
		? (float) $p['threshold']
		: (float) ($defaults_preset['threshold'] ?? 0.4);

	$rootMargin = array_key_exists('rootMargin', $p)
		? (string) $p['rootMargin']
		: (string) ($defaults_preset['rootMargin'] ?? '0px 0px -4% 0px');

	// move
	$direction = array_key_exists('direction', $p)
		? (string) $p['direction']
		: (string) ($defaults_preset['direction'] ?? 'up');

	$distance = array_key_exists('distance', $p)
		? (int) $p['distance']
		: (int) ($defaults_preset['distance'] ?? 24);

	// zoom
	$zoomMode = array_key_exists('zoomMode', $p)
		? (string) $p['zoomMode']
		: (string) ($defaults_preset['zoomMode'] ?? 'in');

	$scaleFrom = array_key_exists('scaleFrom', $p)
		? (float) $p['scaleFrom']
		: (float) ($defaults_preset['scaleFrom'] ?? 0.95);

	$rubberMode = array_key_exists('rubberMode', $p)
		? (string) $p['rubberMode']
		: (string) ($defaults_preset['rubberMode'] ?? 'off');

	$rubberAmp = array_key_exists('rubberAmp', $p)
		? (float) $p['rubberAmp']
		: (float) ($defaults_preset['rubberAmp'] ?? 0.035);

	$rubberBool = ($preset_key === 'zoom')
		? ($rubberMode !== 'off')
		: (array_key_exists('rubber', $p) ? (bool) $p['rubber'] : (bool) ($defaults_preset['rubber'] ?? false));

	// blur
	$blurFrom = array_key_exists('blurFrom', $p)
		? (float) $p['blurFrom']
		: (float) ($defaults_preset['blurFrom'] ?? 10);

	// mask
	$maskVariant = array_key_exists('maskVariant', $p)
		? (string) $p['maskVariant']
		: (string) ($defaults_preset['maskVariant'] ?? 'wipe');

	$maskDirection = array_key_exists('maskDirection', $p)
		? (string) $p['maskDirection']
		: (string) ($defaults_preset['maskDirection'] ?? 'up');

	$maskFeather = array_key_exists('maskFeather', $p)
		? (int) $p['maskFeather']
		: (int) ($defaults_preset['maskFeather'] ?? 24);

	$maskInset = array_key_exists('maskInset', $p)
		? (int) $p['maskInset']
		: (int) ($defaults_preset['maskInset'] ?? 20);

	// ── Render ───────────────────────────────────────────────────────────────

	$__p = $partials_dir . 'preset-card-open.php';
	if (file_exists($__p)) {require $__p;}

	$__p = $partials_dir . 'preset-once.php';
	if (file_exists($__p)) {require $__p;}

	if ($preset_key === 'move') {
		$__p = $partials_dir . 'preset-move.php';
		if (file_exists($__p)) {require $__p;}
	} elseif ($preset_key === 'zoom') {
		$__p = $partials_dir . 'preset-zoom.php';
		if (file_exists($__p)) {require $__p;}
	} elseif ($preset_key === 'blur') {
		$__p = $partials_dir . 'preset-blur.php';
		if (file_exists($__p)) {require $__p;}
	} elseif ($preset_key === 'mask') {
		$__p = $partials_dir . 'preset-mask.php';
		if (file_exists($__p)) {require $__p;}
	}

	$__p = $partials_dir . 'preset-common.php';
	if (file_exists($__p)) {require $__p;}

	$__p = $partials_dir . 'preset-card-close.php';
	if (file_exists($__p)) {require $__p;}
}