<?php
	// includes/Admin/Views/layout.php

	declare (strict_types = 1);

	if (! defined('ABSPATH')) {
	exit;
	}

	/** @var array  $tabs */
	/** @var string $current_tab */
	/** @var string $menu_slug */

	$logo = WP_InView_Helpers::url('assets/img/inview_logo.svg');

?>
<div class="wrap">
  <?php
  	/**
  	 * Reset form MUSI być poza głównym <form action="options.php">.
  	 * HTML nie pozwala na zagnieżdżanie formularzy — przeglądarka ignoruje
  	 * wewnętrzny <form> i każdy submit trafia do zewnętrznego (options.php).
  	 * Renderujemy go tutaj, przed głównym form, i kontrolujemy przez JS.
  	 */
  ?>
  <form id="wp-inview-reset-form" method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>"
    style="display:none" aria-hidden="true">
    <?php wp_nonce_field('wp_inview_reset_settings', '_wpnonce'); ?>
    <input type="hidden" name="action" value="wp_inview_reset_settings">
  </form>

  <form method="post" action="options.php" data-wp-inview-form="1">
    <?php settings_fields('wp_inview'); ?>

    <?php
    	/**
    	 * Ukryte pole z aktywnym tabem.
    	 * WordPress options.php po zapisaniu przekierowuje na wartość
    	 * $_POST['_wp_http_referer'] — ale sanityzuje go i obcina query string.
    	 * Zamiast polegać na refererze, przechwytujemy redirect filtrem
    	 * wp_redirect w Admin.php i doklejamy tab do URL.
    	 * To pole pozwala filtrowi wiedzieć na który tab wrócić.
    	 */
    ?>
    <input type="hidden" name="_wp_inview_current_tab" value="<?php echo esc_attr($current_tab); ?>">

    <div class="wp-inview-admin" data-wp-inview-admin="1">
      <div class="wp-inview-admin__header">
        <div class="wp-inview-admin__header__brand">
          <img src="<?php echo esc_url($logo); ?>" alt="WP InView logo" class="wp-inview-admin__logo" />
        </div>

        <nav class="wp-inview-admin__tabs">
          <?php foreach ($tabs as $key => $tab): ?>
          <?php
          	$key_s = sanitize_key((string) $key);
          	$label = is_array($tab) ? (string) ($tab['label'] ?? '') : '';

          	$base_url = admin_url('options-general.php');
          	$url      = add_query_arg([
          		'page' => $menu_slug,
          		'tab'  => $key_s,
          	], $base_url);

          	$active = ($key_s === $current_tab) ? ' is-active' : '';
          ?>
          <a class="wp-inview-admin__tab<?php echo esc_attr($active); ?>" href="<?php echo esc_url($url); ?>">
            <?php echo esc_html($label); ?>
          </a>
          <?php endforeach; ?>
        </nav>
      </div>

      <h1 class="wp-inview-admin__main-title">WP InView</h1>

      <div class="wp-inview-admin__content">
        <?php
        	$render = $tabs[$current_tab]['render'] ?? null;

        	if (is_callable($render)) {
        		try {
        			call_user_func($render);
        		} catch (\Throwable $e) {
        			if (class_exists('WP_InView_Debug')) {
        				WP_InView_Debug::error('Admin tab render failed', [
        					'tab'     => $current_tab,
        					'message' => $e->getMessage(),
        				]);
        			}
        			echo '<div class="notice notice-error"><p>' . esc_html__('Tab render failed.', 'wp-inview') . '</p></div>';
        		}
        	} else {
        		echo '<div class="notice notice-error"><p>' . esc_html__('Tab renderer not available.', 'wp-inview') . '</p></div>';
        	}
        ?>
      </div>
      <div class="wp-inview-admin__footer">
        <button type="submit" class="wp-inview-btn wp-inview-btn--save">
          <?php echo esc_html__('Save changes', 'wp-inview'); ?>
        </button>
      </div>
    </div>
  </form>
</div>