<?php
// COMPLETE FILE - replace entirely

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

final class WP_InView_Admin_Tab_PageTransition {

	private static function safe_settings(): array {
		try {
			$s = WP_InView_Settings::get();
			return is_array($s) ? $s : [];
		} catch (\Throwable $e) {
			if (class_exists('WP_InView_Debug')) {
				WP_InView_Debug::error('Failed to load settings in PageTransition tab', [
					'message' => $e->getMessage(),
				]);
			}
			return [];
		}
	}

	private static function safe_schema_ui(): array {
		try {
			$ui = WP_InView_Schema::ui_schema();
			return is_array($ui) ? $ui : [];
		} catch (\Throwable $e) {
			if (class_exists('WP_InView_Debug')) {
				WP_InView_Debug::error('Failed to load schema UI in PageTransition tab', [
					'message' => $e->getMessage(),
				]);
			}
			return [];
		}
	}

	public static function render(): void {
		$settings = self::safe_settings();

		$pt = isset($settings['pageTransition']) && is_array($settings['pageTransition'])
			? $settings['pageTransition']
			: [];

		$registry = WP_InView_Schema::page_transition_registry();
		$registry = is_array($registry) ? $registry : [];

		// Defaults as safety net (registry-driven)
		$defaults   = WP_InView_Schema::defaults();
		$ptDefaults = is_array($defaults['pageTransition'] ?? null) ? $defaults['pageTransition'] : [];

		// Enabled: strict checkbox semantics (prefer stored value, fallback default)
		$enabled = isset($pt['enabled'])
			? (bool) $pt['enabled']
			: (bool) ($ptDefaults['enabled'] ?? false);

		// Active variant: fallback to default, then to first registry key
		$activeVariant = isset($pt['activeVariant']) && is_string($pt['activeVariant']) && $pt['activeVariant'] !== ''
			? (string) $pt['activeVariant']
			: (string) ($ptDefaults['activeVariant'] ?? 'fade');

		$variants = isset($pt['variants']) && is_array($pt['variants']) ? $pt['variants'] : [];

		// Ensure all registry variants exist in ctx (important right after adding new variants like blur)
		foreach ($registry as $k => $_def) {
			$k = (string) $k;
			if (! isset($variants[$k]) || ! is_array($variants[$k])) {
				// fallback from defaults if present, else empty
				$variants[$k] = is_array(($ptDefaults['variants'][$k] ?? null)) ? $ptDefaults['variants'][$k] : [];
			}
		}

		$ui    = self::safe_schema_ui();
		$pt_ui = is_array($ui['pageTransition'] ?? null) ? $ui['pageTransition'] : [];

		$ctx = [
			'settings'      => $settings, // future-proof, header may want it
			'enabled'       => $enabled,
			'activeVariant' => $activeVariant,
			'variants'      => $variants,
			'registry'      => $registry,
			'ui'            => $pt_ui,
		];

		$view_path = WP_InView_Helpers::path('includes/Admin/Views/tabs/page-transition/layout.php');
		if (! file_exists($view_path)) {
			echo '<div class="notice notice-error"><p>' . esc_html(__('Page Transition view missing. Check plugin deployment.', 'wp-inview')) . '</p></div>';
			return;
		}

		require $view_path;
	}
}