<?php

declare (strict_types = 1);

if (! defined('ABSPATH')) {
	exit;
}

final class WP_InView_Admin_Tab_Cascade {

	private static function safe_settings(): array {
		try {
			$s = WP_InView_Settings::get();
			return is_array($s) ? $s : [];
		} catch (\Throwable $e) {
			if (class_exists('WP_InView_Debug')) {
				WP_InView_Debug::error('Failed to load settings in Cascade tab', [
					'message' => $e->getMessage(),
				]);
			}
			return [];
		}
	}

	private static function safe_schema_ui(): array {
		try {
			$ui = WP_InView_Schema::ui_schema();
			return is_array($ui) ? $ui : [];
		} catch (\Throwable $e) {
			if (class_exists('WP_InView_Debug')) {
				WP_InView_Debug::error('Failed to load schema UI in Cascade tab', [
					'message' => $e->getMessage(),
				]);
			}
			return [];
		}
	}

	private static function arr($v): array {
		return is_array($v) ? $v : [];
	}

	private static function notice_missing_view(): void {
		echo '<div class="notice notice-error"><p>';
		echo esc_html(__('Cascade tab view file is missing. Check plugin deployment.', 'wp-inview'));
		echo '</p></div>';
	}

	public static function render(): void {
		$settings = self::safe_settings();
		$ui       = self::safe_schema_ui();

		$animation = self::arr($settings['animation'] ?? null);
		$cascade   = self::arr($animation['cascade'] ?? null);

		$anim_ui   = self::arr($ui['animation'] ?? null);
		$cas_ui    = self::arr($anim_ui['cascade'] ?? null);
		$ui_fields = self::arr($cas_ui['fields'] ?? null);

		$ui_cascade_info = self::arr($cas_ui['info'] ?? null);
		$ui_cascade_copy = self::arr($cas_ui['copy'] ?? null);

		$selector = array_key_exists('selector', $cascade) ? (string) $cascade['selector'] : '';
		$limit    = array_key_exists('limit', $cascade) ? (int) $cascade['limit'] : 12;
		$step     = array_key_exists('step', $cascade) ? (int) $cascade['step'] : 120;

		$ui_selector = self::arr($ui_fields['selector'] ?? null);
		$ui_limit    = self::arr($ui_fields['limit'] ?? null);
		$ui_step     = self::arr($ui_fields['step'] ?? null);

		$reset_url = wp_nonce_url(
			admin_url('admin-post.php?action=wp_inview_reset'),
			'wp_inview_reset',
			'_wpnonce_wp_inview_reset'
		);

		$ctx = [
			// values
			'selector'        => $selector,
			'limit'           => $limit,
			'step'            => $step,

			// ui
			'ui_selector'     => $ui_selector,
			'ui_limit'        => $ui_limit,
			'ui_step'         => $ui_step,
			'ui_cascade_info' => $ui_cascade_info,
			'ui_cascade_copy' => $ui_cascade_copy,

			// misc
			'reset_url'       => $reset_url,
		];

		$view_path = WP_InView_Helpers::path('includes/Admin/Views/tabs/cascade/layout.php');
		if (! file_exists($view_path)) {
			if (class_exists('WP_InView_Debug')) {
				WP_InView_Debug::error('Missing cascade tab view file', ['path' => $view_path]);
			}
			self::notice_missing_view();
			return;
		}

		require $view_path;
	}
}
