(function () {
	function clampStr(v, maxLen) {
		var s = v == null ? "" : String(v);
		return s.length > maxLen ? s.slice(0, maxLen) : s;
	}

	function isHexColor(s) {
		// #rgb, #rgba, #rrggbb, #rrggbbaa
		return /^#([0-9a-fA-F]{3}|[0-9a-fA-F]{4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})$/.test(s);
	}

	// Optional, jeśli chcesz dopuścić CSS variables. Bez fallbacków.
	function isCssVar(s) {
		return /^var\(--[a-zA-Z0-9-]+\)$/.test(s);
	}

	function sanitizeColor(raw, fallback) {
		var s = clampStr(raw, 64).trim();

		if (isHexColor(s)) return s;
		if (isCssVar(s)) return s; // usuń tę linię, jeśli chcesz tylko hex

		return fallback;
	}

	try {
		var cfg = window.WP_INVIEW_PT_BOOTSTRAP_CONFIG || {};
		window.__WP_INVIEW_PT_BOOTSTRAP = { ran: true, hadRaw: false, hadState: false, locked: false };

		var k = String(cfg.storageKey || "");
		if (!k) return;

		var raw = sessionStorage.getItem(k);
		window.__WP_INVIEW_PT_BOOTSTRAP.hadRaw = !!raw;
		if (!raw) return;

		var st;
		try {
			st = JSON.parse(raw);
		} catch (e) {
			return;
		}
		window.__WP_INVIEW_PT_BOOTSTRAP.hadState = !!st;
		if (!st) return;

		var className = String(cfg.className || "wp-inview-pt-pre");
		var cssVarBg = String(cfg.cssVarBg || "--wp-inview-pt-pre-bg");
		var defaultBg = String(cfg.defaultBg || "#ffffff");
		var fallbackMs = Number(cfg.fallbackMs || 4000);

		var colorRaw = st && st.overlayColor != null ? st.overlayColor : defaultBg;
		var color = sanitizeColor(colorRaw, defaultBg);

		document.documentElement.classList.add(className);
		document.documentElement.style.setProperty(cssVarBg, color);
		window.__WP_INVIEW_PT_BOOTSTRAP.locked = true;

		setTimeout(function () {
			document.documentElement.classList.remove(className);
		}, fallbackMs);
	} catch (e) {
		try {
			console.error("[WP InView PT bootstrap]", e);
		} catch (_) {}
	}
})();
