(function (w) {
	const Admin = w.WPInViewAdmin;
	if (!Admin) return;

	const Switches = {
		name: "switches",

		init(root, ctx, api) {
			const cleanups = [];

			api.qsa(".wp-inview-switch", root).forEach((sw) => {
				const input = api.qs('input[type="checkbox"]', sw);
				const text = api.qs(".wp-inview-switch__text", sw);
				if (!input || !text) return;

				// Optional overrides:
				// <div class="wp-inview-switch" data-label-on="Enabled" data-label-off="Disabled">
				const labelOn = sw.getAttribute("data-label-on") || "On";
				const labelOff = sw.getAttribute("data-label-off") || "Off";

				const render = () => {
					text.textContent = input.checked ? labelOn : labelOff;
				};

				const onChange = () => {
					render();
					if (api && typeof api.setDirty === "function") {
						api.setDirty(true);
					}
				};

				input.addEventListener("change", onChange);
				render();

				cleanups.push(() => input.removeEventListener("change", onChange));
			});

			return () => {
				cleanups.forEach((fn) => {
					try {
						fn();
					} catch (e) {}
				});
			};
		},
	};

	Admin.register(Switches);
})(window);
