/* assets/js/admin/reset.js */
(function (w, d) {
	const Admin = w.WPInViewAdmin;
	if (!Admin) return;

	const Reset = {
		name: "reset",

		init(root, ctx, api) {
			/**
			 * Przechwytuje klik na [data-wp-inview-reset-trigger] i submituje
			 * formularz resetu (#wp-inview-reset-form) który jest POZA głównym
			 * <form action="options.php"> w layout.php.
			 *
			 * Dlaczego nie <form> wewnątrz Settings tab render?
			 * HTML nie pozwala na zagnieżdżanie formularzy. Przeglądarka ignoruje
			 * wewnętrzny <form> i submit trafia zawsze do zewnętrznego (options.php).
			 * Formularz resetu musi być na poziomie layoutu — stąd id="wp-inview-reset-form".
			 */
			const handler = (e) => {
				const btn = e.target.closest("[data-wp-inview-reset-trigger]");
				if (!btn) return;

				const message = btn.dataset.confirm || "Are you sure you want to restore default settings? This cannot be undone.";

				if (!w.confirm(message)) {
					return;
				}

				// Oznacz jako saving żeby dirty.js nie blokował beforeunload.
				if (typeof Admin.setSaving === "function") {
					Admin.setSaving();
				}

				// Submituj zewnętrzny formularz resetu z layout.php.
				const resetForm = d.getElementById("wp-inview-reset-form");
				if (resetForm) {
					resetForm.submit();
				} else {
					console.error("[WP InView] Reset form #wp-inview-reset-form not found in DOM.");
				}
			};

			root.addEventListener("click", handler);

			return () => {
				root.removeEventListener("click", handler);
			};
		},
	};

	Admin.register(Reset);
})(window, document);
