(function (w) {
	const Admin = w.WPInViewAdmin;
	if (!Admin) return;

	const Duration = {
		name: "duration",

		init(root, ctx, api) {
			api.qsa('[data-wp-inview-card="1"]', root).forEach((card) => {
				const input = api.qs('[data-wp-inview-duration-input="1"]', card);
				const chk = api.qs('[data-wp-inview-extended-duration="1"]', card);
				if (!input || !chk) return;

				const apply = () => {
					const maxDefault = parseInt(chk.getAttribute("data-max-default") || "1200", 10);
					const maxExtended = parseInt(chk.getAttribute("data-max-extended") || "5000", 10);

					input.max = chk.checked ? String(maxExtended) : String(maxDefault);

					const v = parseInt(input.value || "0", 10);
					if (!chk.checked && v > maxDefault) input.value = String(maxDefault);
				};

				chk.addEventListener("change", apply);
				apply();
			});
		},
	};

	Admin.register(Duration);
})(window);
