/* assets/js/admin/color-picker.js */
/* Syncs input[type="color"] with the hidden input and the chip swatch preview. */
(function (w) {
	const Admin = w.WPInViewAdmin;
	if (!Admin) return;

	const ColorPicker = {
		name: "color-picker",

		init(root, ctx, api) {
			const colorInputs = api.qsa('[data-wp-inview-color-input="1"]', root);
			if (!colorInputs.length) return;

			const offs = [];

			colorInputs.forEach((colorInput) => {
				const group = colorInput.closest("[data-wp-inview-chip-group]");
				if (!group) return;

				const hidden = api.qs('[data-wp-inview-value="1"]', group);
				const chip = api.qs('[data-wp-inview-color-chip="1"]', group);
				const swatch = chip ? api.qs(".wp-inview-chip__color-swatch", chip) : null;

				if (!hidden) return;

				const syncSwatch = (color) => {
					if (swatch) swatch.style.background = color;
				};

				const onInput = () => {
					const val = colorInput.value;
					hidden.value = val;
					syncSwatch(val);
					Admin.setDirty(true);
				};

				colorInput.addEventListener("input", onInput);
				offs.push(() => colorInput.removeEventListener("input", onInput));

				// Init swatch from current color input value
				syncSwatch(colorInput.value);
			});

			return () => offs.forEach((fn) => fn());
		},
	};

	Admin.register(ColorPicker);
})(window);
